/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SimpleFeatureCollectionRenderer
extends SimpleRenderer {
    private Collection styles = new ArrayList();
    private Map layerToFeaturesMap = new HashMap();

    public SimpleFeatureCollectionRenderer(Object contentID, LayerViewPanel panel) {
        super(contentID, panel);
    }

    private void paint(Graphics2D g, Collection features, Layer layer, Style style) throws Exception {
        if (!layer.isVisible()) {
            return;
        }
        if (!style.isEnabled()) {
            return;
        }
        style.initialize(layer);
        Iterator i = new ArrayList(features).iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            if (feature.getGeometry().isEmpty()) continue;
            style.paint(feature, g, this.panel.getViewport());
        }
    }

    protected void paint(Graphics2D g) throws Exception {
        Iterator i = this.styles.iterator();
        while (i.hasNext()) {
            Style style = (Style)i.next();
            Iterator j = this.layerToFeaturesMap.keySet().iterator();
            while (j.hasNext()) {
                Layer layer = (Layer)j.next();
                Collection features = (Collection)this.layerToFeaturesMap.get(layer);
                this.paint(g, features, layer, style);
            }
        }
    }

    protected void setLayerToFeaturesMap(Map layerToFeaturesMap) {
        this.layerToFeaturesMap = layerToFeaturesMap;
    }

    protected void setStyles(Collection styles) {
        this.styles = styles;
    }
}

