/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import com.vividsolutions.wms.MapImageFormatChooser;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class URLWizardPanel
extends JPanel
implements WizardPanel {
    public static final String SERVICE_KEY = "SERVICE";
    public static final String FORMAT_KEY = "FORMAT";
    public static final String URL_KEY = "URL";
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map dataMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel urlLabel = new JLabel();
    private JTextField urlTextField = new JTextField();
    private JPanel fillerPanel = new JPanel();
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$plugin$wms$MapLayerWizardPanel;

    public URLWizardPanel(String initialURL) {
        try {
            this.jbInit();
            this.urlTextField.setFont(new JLabel().getFont());
            this.urlTextField.setText(initialURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    void jbInit() throws Exception {
        this.urlLabel.setText("URL:");
        this.setLayout(this.gridBagLayout1);
        this.urlTextField.setPreferredSize(new Dimension(300, 21));
        this.urlTextField.setText("http://");
        this.urlTextField.setCaretPosition(this.urlTextField.getText().length());
        this.urlLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 3) {
                    URLWizardPanel.this.urlTextField.setText("http://slkapps2.env.gov.bc.ca/servlet/com.esri.wms.Esrimap");
                }
                super.mouseClicked(e);
            }
        });
        this.add((Component)this.urlLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.urlTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(2, 10, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getInstructions() {
        return "Please enter the URL of the WMS server. Then press Next to establish the connection.";
    }

    private String fixUrlForWMService(String url) {
        String fixedURL = url.trim();
        if (fixedURL.indexOf("?") == -1) {
            fixedURL = fixedURL + "?";
        } else if (!fixedURL.endsWith("?") && !fixedURL.endsWith("&")) {
            fixedURL = fixedURL + "&";
        }
        return fixedURL;
    }

    public void exitingToRight() throws IOException, WorkbenchException {
        this.dataMap.put(URL_KEY, this.urlTextField.getText());
        String url = this.fixUrlForWMService(this.urlTextField.getText());
        WMService service = new WMService(url);
        service.initialize();
        this.dataMap.put(SERVICE_KEY, service);
        MapImageFormatChooser formatChooser = new MapImageFormatChooser();
        String format = formatChooser.chooseFormat(service.getCapabilities().getMapFormats());
        if (format == null) {
            throw new WorkbenchException("The server does not support GIF, PNG, or JPEG formats");
        }
        this.dataMap.put(FORMAT_KEY, format);
        this.dataMap.put("INITIAL_LAYER_NAMES", null);
        formatChooser.setPreferLossyCompression(false);
        formatChooser.setTransparencyRequired(true);
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        this.urlTextField.setCaretPosition(0);
        this.urlTextField.moveCaretPosition(this.urlTextField.getText().length());
    }

    public String getTitle() {
        return "Select Uniform Resource Locator (URL)";
    }

    public String getID() {
        return this.getClass().getName();
    }

    public boolean isInputValid() {
        return true;
    }

    public String getNextID() {
        return (class$com$vividsolutions$jump$workbench$ui$plugin$wms$MapLayerWizardPanel == null ? (class$com$vividsolutions$jump$workbench$ui$plugin$wms$MapLayerWizardPanel = URLWizardPanel.class$("com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerWizardPanel")) : class$com$vividsolutions$jump$workbench$ui$plugin$wms$MapLayerWizardPanel).getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

