/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SRSUtils;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class EditWMSQueryPanel
extends JPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private MapLayerPanel mapLayerPanel = new MapLayerPanel();
    private JLabel srsLabel = new JLabel();
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private JComboBox srsComboBox = new JComboBox(this.comboBoxModel);
    private Border border1;
    private TransparencyPanel transparencyPanel = new TransparencyPanel();
    private JLabel transparencyLabel = new JLabel();
    private JLabel urlLabel = new JLabel();
    private JTextField urlTextField = new JTextField();
    private EnableCheck[] enableChecks = new EnableCheck[]{new EnableCheck(){

        public String check(JComponent component) {
            return EditWMSQueryPanel.this.mapLayerPanel.getChosenMapLayers().isEmpty() ? "At least one WMS layer must be chosen" : null;
        }
    }, new EnableCheck(){

        public String check(JComponent component) {
            return EditWMSQueryPanel.this.srsComboBox.getSelectedItem() == null ? "The chosen layers do not have a common EPSG coordinate reference system." : null;
        }
    }};

    public EditWMSQueryPanel(WMService service, List initialChosenMapLayers, String initialSRS, int alpha) {
        try {
            this.jbInit();
            String url = service.getServerUrl();
            if (url.endsWith("?") || url.endsWith("&")) {
                url = url.substring(0, url.length() - 1);
            }
            this.urlTextField.setText(url);
            this.mapLayerPanel.init(service, initialChosenMapLayers);
            this.updateComboBox();
            String srsName = SRSUtils.getName(initialSRS);
            this.srsComboBox.setSelectedItem(srsName);
            this.mapLayerPanel.add(new InputChangedListener(){

                public void inputChanged() {
                    EditWMSQueryPanel.this.updateComboBox();
                }
            });
            this.setAlpha(alpha);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getAlpha() {
        return 255 - this.transparencyPanel.getSlider().getValue();
    }

    private void setAlpha(int alpha) {
        this.transparencyPanel.getSlider().setValue(255 - alpha);
    }

    public String getSRS() {
        int index = this.srsComboBox.getSelectedIndex();
        String srsCode = (String)this.mapLayerPanel.commonSRSList().get(index);
        return srsCode;
    }

    private void updateComboBox() {
        String selectedSRS = (String)this.srsComboBox.getSelectedItem();
        this.comboBoxModel.removeAllElements();
        Iterator i = this.mapLayerPanel.commonSRSList().iterator();
        while (i.hasNext()) {
            String commonSRS = (String)i.next();
            String srsName = SRSUtils.getName(commonSRS);
            this.comboBoxModel.addElement(srsName);
        }
        this.srsComboBox.setSelectedItem(selectedSRS);
        if (this.srsComboBox.getSelectedItem() == null && this.srsComboBox.getItemCount() > 0) {
            this.srsComboBox.setSelectedIndex(0);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setLayout(this.gridBagLayout1);
        this.srsLabel.setText("Coordinate Reference System:");
        this.setBorder(this.border1);
        this.setToolTipText("");
        this.srsComboBox.setMinimumSize(new Dimension(125, 21));
        this.srsComboBox.setToolTipText("");
        this.transparencyLabel.setText("Transparency:");
        this.urlLabel.setText("URL:");
        this.urlTextField.setBorder(null);
        this.urlTextField.setOpaque(false);
        this.urlTextField.setEditable(false);
        this.add((Component)this.mapLayerPanel, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        this.add((Component)this.srsLabel, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 5), 0, 0));
        this.add((Component)this.srsComboBox, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.transparencyPanel, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.transparencyLabel, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.urlLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.urlTextField, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public List getChosenMapLayers() {
        return this.mapLayerPanel.getChosenMapLayers();
    }

    public EnableCheck[] getEnableChecks() {
        return this.enableChecks;
    }
}

