/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.test;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.GeometryMicroscope;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicroscopePlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        EnableCheckFactory checkFactory = new EnableCheckFactory(context.getWorkbenchContext());
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{"Tools", "Test"}, this.getName(), false, null, new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        FeatureCollectionWrapper fc = context.getSelectedLayer(0).getFeatureCollectionWrapper();
        Envelope fence = context.getLayerViewPanel().getFence().getEnvelopeInternal();
        FeatureCollection magFC = this.magnify(fc, fence);
        Layer lyr = context.addLayer("QA", "Microscope", magFC);
        lyr.getBasicStyle().setFillColor(Color.red);
        lyr.getBasicStyle().setLineColor(Color.red);
        lyr.getBasicStyle().setAlpha(100);
        lyr.getVertexStyle().setEnabled(true);
        lyr.fireAppearanceChanged();
        return true;
    }

    private FeatureCollection magnify(FeatureCollection fc, Envelope env) {
        ArrayList<Object> geomList = new ArrayList<Object>();
        Iterator i = fc.query(env).iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            geomList.add(feature.getGeometry().clone());
        }
        double minSep = env.getWidth() / 20.0;
        GeometryMicroscope micro = new GeometryMicroscope(geomList, env, minSep);
        List result = micro.getAdjusted();
        return FeatureDatasetFactory.createFromGeometry(result);
    }
}

