/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.SchemaPanel;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ViewSchemaPlugIn
extends AbstractPlugIn {
    private static final String KEY = (class$com$vividsolutions$jump$workbench$ui$plugin$ViewSchemaPlugIn == null ? (class$com$vividsolutions$jump$workbench$ui$plugin$ViewSchemaPlugIn = ViewSchemaPlugIn.class$("com.vividsolutions.jump.workbench.ui.plugin.ViewSchemaPlugIn")) : class$com$vividsolutions$jump$workbench$ui$plugin$ViewSchemaPlugIn) + " - FRAME";
    private EditingPlugIn editingPlugIn;
    private GeometryFactory factory = new GeometryFactory();
    private WKTReader wktReader = new WKTReader(this.factory);
    private FlexibleDateParser dateParser = new FlexibleDateParser();
    private DateFormat dateFormatter = DateFormat.getDateInstance();
    public static final ImageIcon ICON = IconLoader.icon("Object.gif");
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$plugin$ViewSchemaPlugIn;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$model$Layerable;

    public ViewSchemaPlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }

    public String getName() {
        return "View / Edit Schema";
    }

    private void applyChanges(Layer layer, SchemaPanel panel) throws Exception {
        if (!panel.isModified()) {
            return;
        }
        if (panel.validateInput() != null) {
            throw new Exception(panel.validateInput());
        }
        panel.getModel().removeBlankRows();
        FeatureSchema newSchema = new FeatureSchema();
        for (int i = 0; i < panel.getModel().getRowCount(); ++i) {
            newSchema.addAttribute(panel.getModel().get(i).getName(), panel.getModel().get(i).getType());
        }
        List originalFeatures = layer.getFeatureCollectionWrapper().getFeatures();
        ArrayList<Feature> tempFeatures = new ArrayList<Feature>();
        Iterator i = layer.getFeatureCollectionWrapper().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            tempFeatures.add(this.convert(feature, panel, newSchema));
        }
        for (int i2 = 0; i2 < originalFeatures.size(); ++i2) {
            Feature originalFeature = (Feature)originalFeatures.get(i2);
            Feature tempFeature = (Feature)tempFeatures.get(i2);
            originalFeature.setSchema(tempFeature.getSchema());
            originalFeature.setAttributes(tempFeature.getAttributes());
        }
        layer.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
        layer.setFeatureCollection(new FeatureDataset(originalFeatures, newSchema));
        layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        panel.markAsUnmodified();
    }

    private Feature convert(Feature oldFeature, SchemaPanel panel, FeatureSchema newSchema) throws ConversionException {
        BasicFeature newFeature = new BasicFeature(newSchema);
        for (int i = 0; i < panel.getModel().getRowCount(); ++i) {
            if (panel.getModel().get(i).getOriginalIndex() == -1) {
                newFeature.setAttribute(i, (Object)(panel.getModel().get(i).getType() == AttributeType.GEOMETRY ? oldFeature.getGeometry() : null));
                continue;
            }
            newFeature.setAttribute(i, this.convert(oldFeature.getAttribute(panel.getModel().get(i).getOriginalIndex()), oldFeature.getSchema().getAttributeType(panel.getModel().get(i).getOriginalIndex()), newFeature.getSchema().getAttributeType(i), panel.getModel().get(i).getName(), panel.isForcingInvalidConversionsToNull()));
        }
        return newFeature;
    }

    private String limitLength(String s) {
        return StringUtil.limitLength(s, 30);
    }

    private Object convert(Object oldValue, AttributeType oldType, AttributeType newType, String name, boolean forcingInvalidConversionsToNull) throws ConversionException {
        try {
            if (oldValue == null) {
                return newType == AttributeType.GEOMETRY ? this.factory.createPoint((Coordinate)null) : null;
            }
            if (oldType == AttributeType.STRING) {
                String oldString = (String)oldValue;
                if (newType == AttributeType.STRING) {
                    return oldString;
                }
                if (newType == AttributeType.INTEGER) {
                    try {
                        return new Integer(oldString);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("Cannot convert to integer: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.DOUBLE) {
                    try {
                        return new Double(oldString);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("Cannot convert to double: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.GEOMETRY) {
                    try {
                        return this.wktReader.read(oldString);
                    }
                    catch (com.vividsolutions.jts.io.ParseException e) {
                        throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.DATE) {
                    try {
                        return this.dateParser.parse(oldString, false);
                    }
                    catch (ParseException e) {
                        throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
            }
            if (oldType == AttributeType.INTEGER) {
                int oldInt = (Integer)oldValue;
                if (newType == AttributeType.STRING) {
                    return "" + oldInt;
                }
                if (newType == AttributeType.INTEGER) {
                    return oldValue;
                }
                if (newType == AttributeType.DOUBLE) {
                    return new Double(oldInt);
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    try {
                        return this.dateParser.parse("" + oldInt, false);
                    }
                    catch (ParseException e) {
                        throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
            }
            if (oldType == AttributeType.DOUBLE) {
                double oldDouble = (Double)oldValue;
                if (newType == AttributeType.STRING) {
                    return "" + oldDouble;
                }
                if (newType == AttributeType.INTEGER) {
                    return new Integer((int)oldDouble);
                }
                if (newType == AttributeType.DOUBLE) {
                    return oldValue;
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
            }
            if (oldType == AttributeType.GEOMETRY) {
                Geometry oldGeometry = (Geometry)oldValue;
                if (newType == AttributeType.STRING) {
                    return oldGeometry.toString();
                }
                if (newType == AttributeType.INTEGER) {
                    throw new ConversionException("Cannot convert to integer: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DOUBLE) {
                    throw new ConversionException("Cannot convert to double: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.GEOMETRY) {
                    return oldGeometry;
                }
                if (newType == AttributeType.DATE) {
                    throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
            }
            if (oldType == AttributeType.DATE) {
                Date oldDate = (Date)oldValue;
                if (newType == AttributeType.STRING) {
                    return this.dateFormatter.format(oldDate);
                }
                if (newType == AttributeType.INTEGER) {
                    return new Integer((int)oldDate.getTime());
                }
                if (newType == AttributeType.DOUBLE) {
                    return new Double(oldDate.getTime());
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    return oldValue;
                }
            }
            Assert.shouldNeverReachHere((String)newType.toString());
            return null;
        }
        catch (ConversionException e) {
            if (forcingInvalidConversionsToNull) {
                return newType == AttributeType.GEOMETRY ? this.factory.createPoint((Coordinate)null) : null;
            }
            throw e;
        }
    }

    private void commitEditsInProgress(SchemaPanel panel) {
        if (panel.getTable().getEditingRow() != -1) {
            panel.getTable().getCellEditor(panel.getTable().getEditingRow(), panel.getTable().getEditingColumn()).stopCellEditing();
        }
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (this.frame(context) == null) {
            context.getSelectedLayer(0).getBlackboard().put(KEY, new EditSchemaFrame(context.getWorkbenchFrame(), context.getSelectedLayer(0), this.editingPlugIn));
        }
        this.frame(context).surface();
        return true;
    }

    private EditSchemaFrame frame(PlugInContext context) {
        return (EditSchemaFrame)context.getSelectedLayer(0).getBlackboard().get(KEY);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$300(ViewSchemaPlugIn x0, SchemaPanel x1) {
        x0.commitEditsInProgress(x1);
    }

    static /* synthetic */ void access$400(ViewSchemaPlugIn x0, Layer x1, SchemaPanel x2) throws Exception {
        x0.applyChanges(x1, x2);
    }

    private class EditSchemaFrame
    extends JInternalFrame
    implements LayerNamePanelProxy,
    LayerNamePanel,
    LayerManagerProxy {
        private LayerManager layerManager;
        private Layer layer;
        private WorkbenchFrame workbenchFrame;

        public EditSchemaFrame(WorkbenchFrame workbenchFrame, Layer layer, EditingPlugIn editingPlugIn) {
            this.layer = layer;
            this.workbenchFrame = workbenchFrame;
            layer.getBlackboard().put(KEY, this);
            this.layerManager = layer.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(this, layer){
                private final /* synthetic */ Layer val$layer;
                private final /* synthetic */ EditSchemaFrame this$1;
                {
                    this.this$1 = this$1;
                    this.val$layer = val$layer;
                }

                public void internalFrameClosed(InternalFrameEvent e) {
                    this.val$layer.getBlackboard().put(ViewSchemaPlugIn.access$000(), null);
                }
            });
            SchemaPanel panel = new SchemaPanel(layer, editingPlugIn, workbenchFrame.getContext());
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "Center");
            this.setSize(500, 300);
            this.updateTitle(layer);
            layer.getLayerManager().addLayerListener(new LayerListener(this, layer){
                private final /* synthetic */ Layer val$layer;
                private final /* synthetic */ EditSchemaFrame this$1;
                {
                    this.this$1 = this$1;
                    this.val$layer = val$layer;
                }

                public void categoryChanged(CategoryEvent e) {
                }

                public void featuresChanged(FeatureEvent e) {
                }

                public void layerChanged(LayerEvent e) {
                    EditSchemaFrame.access$100(this.this$1, this.val$layer);
                }
            });
            this.setDefaultCloseOperation(0);
            panel.add(new ActionListener(this, panel, layer, workbenchFrame){
                private final /* synthetic */ SchemaPanel val$panel;
                private final /* synthetic */ Layer val$layer;
                private final /* synthetic */ WorkbenchFrame val$workbenchFrame;
                private final /* synthetic */ EditSchemaFrame this$1;
                {
                    this.this$1 = this$1;
                    this.val$panel = val$panel;
                    this.val$layer = val$layer;
                    this.val$workbenchFrame = val$workbenchFrame;
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        ViewSchemaPlugIn.access$300(EditSchemaFrame.access$200(this.this$1), this.val$panel);
                        ViewSchemaPlugIn.access$400(EditSchemaFrame.access$200(this.this$1), this.val$layer, this.val$panel);
                    }
                    catch (Exception x) {
                        this.val$workbenchFrame.handleThrowable(x);
                    }
                }
            });
            this.addInternalFrameListener(new InternalFrameAdapter(this, panel, layer, ViewSchemaPlugIn.this, workbenchFrame){
                private final /* synthetic */ SchemaPanel val$panel;
                private final /* synthetic */ Layer val$layer;
                private final /* synthetic */ ViewSchemaPlugIn val$this$0;
                private final /* synthetic */ WorkbenchFrame val$workbenchFrame;
                private final /* synthetic */ EditSchemaFrame this$1;
                {
                    this.this$1 = this$1;
                    this.val$panel = val$panel;
                    this.val$layer = val$layer;
                    this.val$this$0 = val$this$0;
                    this.val$workbenchFrame = val$workbenchFrame;
                }

                public void internalFrameClosing(InternalFrameEvent e) {
                    ViewSchemaPlugIn.access$300(EditSchemaFrame.access$200(this.this$1), this.val$panel);
                    if (!this.val$layer.isEditable() || !this.val$panel.isModified()) {
                        this.this$1.dispose();
                        return;
                    }
                    switch (JOptionPane.showConfirmDialog(this.this$1, "Apply changes to the schema?", "JUMP", 1, 2)) {
                        case 0: {
                            try {
                                ViewSchemaPlugIn.access$400(EditSchemaFrame.access$200(this.this$1), this.val$layer, this.val$panel);
                            }
                            catch (Exception x) {
                                this.val$workbenchFrame.handleThrowable(x);
                                return;
                            }
                            this.this$1.dispose();
                            return;
                        }
                        case 1: {
                            this.this$1.dispose();
                            return;
                        }
                        case 2: {
                            return;
                        }
                    }
                    Assert.shouldNeverReachHere();
                }
            });
        }

        private void updateTitle(Layer layer) {
            this.setTitle((layer.isEditable() ? "Edit" : "View") + " Schema: " + layer.getName());
        }

        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        public Layer chooseEditableLayer() {
            return TreeLayerNamePanel.chooseEditableLayer(this);
        }

        public void surface() {
            if (!this.workbenchFrame.hasInternalFrame(this)) {
                this.workbenchFrame.addInternalFrame(this, false, true);
            }
            this.workbenchFrame.activateFrame(this);
            this.moveToFront();
        }

        public LayerNamePanel getLayerNamePanel() {
            return this;
        }

        public Collection getSelectedCategories() {
            return new ArrayList();
        }

        public Layer[] getSelectedLayers() {
            return new Layer[]{this.layer};
        }

        public Collection selectedNodes(Class c) {
            if (!(class$com$vividsolutions$jump$workbench$model$Layerable == null ? (class$com$vividsolutions$jump$workbench$model$Layerable = ViewSchemaPlugIn.class$("com.vividsolutions.jump.workbench.model.Layerable")) : class$com$vividsolutions$jump$workbench$model$Layerable).isAssignableFrom(c)) {
                return new ArrayList();
            }
            return Arrays.asList(this.getSelectedLayers());
        }

        public void addListener(LayerNamePanelListener listener) {
        }

        public void removeListener(LayerNamePanelListener listener) {
        }

        static /* synthetic */ void access$100(EditSchemaFrame x0, Layer x1) {
            x0.updateTitle(x1);
        }

        static /* synthetic */ ViewSchemaPlugIn access$200(EditSchemaFrame x0) {
            return x0.ViewSchemaPlugIn.this;
        }
    }

    private static class ConversionException
    extends Exception {
        public ConversionException(String message) {
            super(message);
        }
    }
}

