/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.driver.AbstractOutputDriver;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.DriverDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;

public class SaveDatasetAsPlugIn
extends ThreadedBasePlugIn {
    private DriverDialog saveDatasetDialog;
    private Layer layer;

    public void initialize(PlugInContext context) throws Exception {
        this.saveDatasetDialog = new DriverDialog(context.getWorkbenchFrame(), "Save Dataset", true);
        this.saveDatasetDialog.initialize(context.getDriverManager().getOutputDrivers());
        GUIUtil.centreOnWindow(this.saveDatasetDialog);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public String getName() {
        return "Save Dataset As (old)";
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.layer = context.getSelectedLayer(0);
        this.saveDatasetDialog.setLayer(this.layer);
        this.saveDatasetDialog.setVisible(true);
        return this.saveDatasetDialog.wasOKPressed();
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (!this.saveDatasetDialog.wasOKPressed()) {
            return;
        }
        AbstractOutputDriver outputDriver = (AbstractOutputDriver)this.saveDatasetDialog.getCurrentDriver();
        monitor.report("Saving " + this.layer.getName() + "...");
        outputDriver.output(this.layer);
    }
}

