/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import javax.swing.JComponent;

public class MoveLayerablePlugIn
extends AbstractPlugIn {
    public static final MoveLayerablePlugIn UP = new MoveLayerablePlugIn(-1){

        public String getName() {
            return "Move Layer Up";
        }

        public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
            return super.createEnableCheck(workbenchContext).add(new EnableCheck(this, workbenchContext){
                private final /* synthetic */ WorkbenchContext val$workbenchContext;
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                    this.val$workbenchContext = val$workbenchContext;
                }

                public String check(JComponent component) {
                    return this.this$0.index(this.this$0.selectedLayerable(this.val$workbenchContext.getLayerNamePanel())) == 0 ? "Layer is already at the top" : null;
                }
            });
        }
    };
    public static final MoveLayerablePlugIn DOWN = new MoveLayerablePlugIn(1){

        public String getName() {
            return "Move Layer Down";
        }

        public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
            return super.createEnableCheck(workbenchContext).add(new EnableCheck(this, workbenchContext){
                private final /* synthetic */ WorkbenchContext val$workbenchContext;
                private final /* synthetic */ 2 this$0;
                {
                    this.this$0 = this$0;
                    this.val$workbenchContext = val$workbenchContext;
                }

                public String check(JComponent component) {
                    return this.this$0.index(this.this$0.selectedLayerable(this.val$workbenchContext.getLayerNamePanel())) == this.val$workbenchContext.getLayerViewPanel().getLayerManager().getCategory(this.this$0.selectedLayerable(this.val$workbenchContext.getLayerNamePanel())).getLayerables().size() - 1 ? "Layer is already at the bottom" : null;
                }
            });
        }
    };
    private int displacement;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$model$Layerable;

    private MoveLayerablePlugIn(int displacement) {
        this.displacement = displacement;
    }

    protected Layerable selectedLayerable(LayerNamePanel layerNamePanel) {
        return (Layerable)layerNamePanel.selectedNodes(class$com$vividsolutions$jump$workbench$model$Layerable == null ? (class$com$vividsolutions$jump$workbench$model$Layerable = MoveLayerablePlugIn.class$("com.vividsolutions.jump.workbench.model.Layerable")) : class$com$vividsolutions$jump$workbench$model$Layerable).iterator().next();
    }

    public boolean execute(final PlugInContext context) throws Exception {
        final Layerable layerable = this.selectedLayerable(context.getLayerNamePanel());
        final int index = this.index(layerable);
        final Category category = context.getLayerManager().getCategory(layerable);
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                this.moveLayerable(index + MoveLayerablePlugIn.this.displacement);
            }

            public void unexecute() {
                this.moveLayerable(index);
            }

            private void moveLayerable(int newIndex) {
                context.getLayerManager().remove(layerable);
                category.add(newIndex, layerable);
            }
        }, context);
        return true;
    }

    protected int index(Layerable layerable) {
        return layerable.getLayerManager().getCategory(layerable).indexOf(layerable);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, class$com$vividsolutions$jump$workbench$model$Layerable == null ? (class$com$vividsolutions$jump$workbench$model$Layerable = MoveLayerablePlugIn.class$("com.vividsolutions.jump.workbench.model.Layerable")) : class$com$vividsolutions$jump$workbench$model$Layerable));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

