/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DeleteAllFeaturesPlugIn
extends AbstractPlugIn {
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        Iterator<Layer> i = Arrays.asList(context.getLayerNamePanel().getSelectedLayers()).iterator();
        while (i.hasNext()) {
            Layer layer = i.next();
            transactions.add(this.createTransaction(layer, context));
        }
        return EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, PlugInContext context) {
        EditTransaction transaction = new EditTransaction(new ArrayList(), this.getName(), layer, this.isRollingBackInvalidEdits(context), true, context.getWorkbenchFrame());
        Iterator i = layer.getFeatureCollectionWrapper().getFeatures().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            transaction.deleteFeature(feature);
        }
        return transaction;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck());
    }
}

