/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;

public abstract class PolygonTool
extends MultiClickTool {
    protected Polygon getPolygon() throws NoninvertibleTransformException {
        ArrayList<Coordinate> closedPoints = new ArrayList<Coordinate>(this.getCoordinates());
        if (!closedPoints.get(0).equals(closedPoints.get(closedPoints.size() - 1))) {
            closedPoints.add(new Coordinate((Coordinate)closedPoints.get(0)));
        }
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(this.toArray(closedPoints)), null);
    }

    protected boolean checkPolygon() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 3) {
            this.getPanel().getContext().warnUser("The polygon must have at least 3 points");
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getPolygon());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

