/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class AbstractPlugIn
implements PlugIn {
    private String name;

    protected void execute(UndoableCommand command, PlugInContext context) {
        AbstractPlugIn.execute(command, context.getLayerViewPanel());
    }

    public AbstractPlugIn() {
    }

    public AbstractPlugIn(String name) {
        this.name = name;
    }

    public void initialize(PlugInContext context) throws Exception {
    }

    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    public String getName() {
        return this.name == null ? AbstractPlugIn.createName(this.getClass()) : this.name;
    }

    public static String createName(Class plugInClass) {
        return StringUtil.toFriendlyName(plugInClass.getName(), "PlugIn");
    }

    public static ActionListener toActionListener(final PlugIn plugIn, final WorkbenchContext workbenchContext, final TaskMonitorManager taskMonitorManager) {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    UndoableEditReceiver undoableEditReceiver;
                    workbenchContext.getWorkbench().getFrame().setStatusMessage("");
                    workbenchContext.getWorkbench().getFrame().log("Executing " + plugIn.getName());
                    PlugInContext plugInContext = workbenchContext.createPlugInContext();
                    UndoableEditReceiver undoableEditReceiver2 = undoableEditReceiver = workbenchContext.getLayerManager() != null ? workbenchContext.getLayerManager().getUndoableEditReceiver() : null;
                    if (undoableEditReceiver != null) {
                        undoableEditReceiver.startReceiving();
                    }
                    try {
                        boolean executeComplete = plugIn.execute(plugInContext);
                        if (plugIn instanceof ThreadedPlugIn && executeComplete) {
                            taskMonitorManager.execute((ThreadedPlugIn)plugIn, plugInContext);
                        }
                    }
                    finally {
                        if (undoableEditReceiver != null) {
                            undoableEditReceiver.stopReceiving();
                        }
                    }
                    workbenchContext.getWorkbench().getFrame().log("Done. Current committed memory: " + workbenchContext.getWorkbench().getFrame().getMBCommittedMemory() + " MB");
                }
                catch (Throwable t) {
                    workbenchContext.getErrorHandler().handleThrowable(t);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(UndoableCommand command, LayerManagerProxy layerManagerProxy) {
        boolean exceptionOccurred = true;
        try {
            command.execute();
            exceptionOccurred = false;
            Object var4_3 = null;
            if (exceptionOccurred) {
                layerManagerProxy.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (exceptionOccurred) {
                layerManagerProxy.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
            throw throwable;
        }
        layerManagerProxy.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
    }

    public String toString() {
        return this.getName();
    }

    protected void reportNothingToUndoYet(PlugInContext context) {
        if (context.getLayerManager() == null) {
            return;
        }
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
    }

    protected boolean isRollingBackInvalidEdits(PlugInContext context) {
        return context.getWorkbenchContext().getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }
}

