/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WorkbenchPropertiesFile
implements WorkbenchProperties {
    private ErrorHandler errorHandler;
    private Element root;

    public WorkbenchPropertiesFile(File file, ErrorHandler errorHandler) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        this.root = document.getRootElement();
        this.errorHandler = errorHandler;
    }

    public List getPlugInClasses() {
        ArrayList plugInClasses = new ArrayList();
        Iterator i = this.root.getChildren("plug-in").iterator();
        while (i.hasNext()) {
            Element plugInElement = (Element)i.next();
            try {
                plugInClasses.add(Class.forName(plugInElement.getTextTrim()));
            }
            catch (ClassNotFoundException e) {
                this.errorHandler.handleThrowable(e);
            }
        }
        return plugInClasses;
    }

    public List getInputDriverClasses() throws ClassNotFoundException {
        ArrayList inputDriverClasses = new ArrayList();
        Iterator i = this.root.getChildren("input-driver").iterator();
        while (i.hasNext()) {
            Element inputDriverElement = (Element)i.next();
            inputDriverClasses.add(Class.forName(inputDriverElement.getTextTrim()));
        }
        return inputDriverClasses;
    }

    public List getOutputDriverClasses() throws ClassNotFoundException {
        ArrayList outputDriverClasses = new ArrayList();
        Iterator i = this.root.getChildren("output-driver").iterator();
        while (i.hasNext()) {
            Element outputDriverElement = (Element)i.next();
            outputDriverClasses.add(Class.forName(outputDriverElement.getTextTrim()));
        }
        return outputDriverClasses;
    }

    public List getConfigurationClasses() throws ClassNotFoundException {
        ArrayList getConfigurationClasses = new ArrayList();
        Iterator i = this.root.getChildren("extension").iterator();
        while (i.hasNext()) {
            Element configurationElement = (Element)i.next();
            getConfigurationClasses.add(Class.forName(configurationElement.getTextTrim()));
        }
        return getConfigurationClasses;
    }
}

