/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtil {
    public static final String newLine = System.getProperty("line.separator");

    public static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public static String getStackTrace(Throwable throwable, int n) {
        String string = "";
        StringReader stringReader = new StringReader(StringUtil.getStackTrace(throwable));
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        for (int i = 0; i < n; ++i) {
            try {
                string = string + lineNumberReader.readLine() + newLine;
                continue;
            }
            catch (IOException iOException) {
                Assert.shouldNeverReachHere();
            }
        }
        return string;
    }

    public static String getTimeString(long l) {
        long l2 = l;
        long l3 = l2 / 86400000L;
        long l4 = (l2 %= 86400000L) / 3600000L;
        long l5 = (l2 %= 3600000L) / 60000L;
        long l6 = (l2 %= 60000L) / 1000L;
        return l3 + "d " + l4 + "h " + l5 + "m " + l6 + "s";
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        return StringUtil.contains(string.toLowerCase(), string2.toLowerCase());
    }

    public static boolean contains(String string, String string2) {
        return string.indexOf(string2) > -1;
    }

    public static String replace(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String stringOfChar(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String indent(String string, int n) {
        String string2 = StringUtil.stringOfChar(' ', n);
        String string3 = string2 + string;
        string3 = StringUtil.replaceAll(string3, "\r\n", "<<<<.CRLF.>>>>");
        string3 = StringUtil.replaceAll(string3, "\r", "<<<<.CR.>>>>");
        string3 = StringUtil.replaceAll(string3, "\n", "<<<<.LF.>>>>");
        string3 = StringUtil.replaceAll(string3, "<<<<.CRLF.>>>>", "\r\n" + string2);
        string3 = StringUtil.replaceAll(string3, "<<<<.CR.>>>>", "\r" + string2);
        string3 = StringUtil.replaceAll(string3, "<<<<.LF.>>>>", "\n" + string2);
        return string3;
    }

    public static Vector toUpperCase(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            vector2.add(string.toUpperCase());
        }
        return vector2;
    }

    public static Vector toLowerCase(List list) {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            vector.add(string.toLowerCase());
        }
        return vector;
    }

    public static String toCommaDelimitedStringInQuotes(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(",'" + e.toString() + "'");
        }
        return stringBuffer.substring(1);
    }

    public static String toCommaDelimitedString(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(", " + e.toString());
        }
        return stringBuffer.substring(1);
    }

    public static List fromCommaDelimitedString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().toString().trim());
        }
        return arrayList;
    }

    public static String toStringNeverNull(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static void replace(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (stringBuffer == null || string == null || string.length() == 0 || string2 == null) {
            throw new IllegalArgumentException("Null or zero-length String");
        }
        int n = 0;
        while (n + string.length() <= stringBuffer.length()) {
            if (stringBuffer.substring(n, n + string.length()).equals(string)) {
                stringBuffer.replace(n, n + string.length(), string2);
                if (!bl) break;
                n += string2.length();
                continue;
            }
            ++n;
        }
    }

    public static String replaceAll(String string, String string2, String string3) {
        return StringUtil.replace(string, string2, string3, true);
    }

    public static String replaceFirst(String string, String string2, String string3) {
        return StringUtil.replace(string, string2, string3, false);
    }

    public static String leftPad(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        return StringUtil.stringOfChar(c, n - string.length()) + string;
    }

    public static String rightPad(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        return string + StringUtil.stringOfChar(c, n - string.length());
    }

    public static String stripHTMLTags(String string) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("<")) {
                bl = true;
                bl2 = false;
                continue;
            }
            if (string2.equalsIgnoreCase(">")) {
                bl = false;
                continue;
            }
            if (bl || string2.trim().length() == 0) continue;
            if (!bl2) {
                stringBuffer.append("\n");
            }
            bl2 = true;
            stringBuffer.append(string2.trim());
        }
        return stringBuffer.toString();
    }

    public static String format(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = Math.round(d2 * d);
        return (int)Math.floor(d3 / d2) + "." + (int)(d3 % d2);
    }

    public static String split(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (i % n == 0 && i > 0) {
                bl = true;
            }
            char c = string.charAt(i);
            if (bl && c == ' ') {
                stringBuffer.append("\n");
                bl = false;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String removeVowels(String string) {
        String string2 = string;
        string2 = StringUtil.replaceAll(string, "a", "");
        string2 = StringUtil.replaceAll(string, "e", "");
        string2 = StringUtil.replaceAll(string, "i", "");
        string2 = StringUtil.replaceAll(string, "o", "");
        string2 = StringUtil.replaceAll(string, "u", "");
        string2 = StringUtil.replaceAll(string, "A", "");
        string2 = StringUtil.replaceAll(string, "E", "");
        string2 = StringUtil.replaceAll(string, "I", "");
        string2 = StringUtil.replaceAll(string, "O", "");
        string2 = StringUtil.replaceAll(string, "U", "");
        return string2;
    }

    public static String removeVowelsSkipStarts(String string) {
        String string2 = string;
        if (!string.startsWith(" ")) {
            string2 = string2.substring(1);
        }
        string2 = StringUtil.encodeStartingVowels(string2);
        string2 = StringUtil.removeVowels(string2);
        string2 = StringUtil.decodeStartingVowels(string2);
        if (!string.startsWith(" ")) {
            string2 = string.charAt(0) + string2;
        }
        return string2;
    }

    public static String removeConsecutiveDuplicates(String string) {
        String string2 = "??";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String string3 = string.charAt(i) + "";
            if (!string2.equalsIgnoreCase(string3)) {
                stringBuffer.append(string3);
            }
            string2 = string3;
        }
        return stringBuffer.toString();
    }

    public static int indexOfIgnoreParentheses(char c, String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '(') {
                ++n2;
                continue;
            }
            if (c2 == ')') {
                --n2;
                continue;
            }
            if (c2 != c || n2 != 0) continue;
            return i;
        }
        return -1;
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringUtil.replace(stringBuffer, string2, string3, bl);
        return stringBuffer.toString();
    }

    private static String encodeStartingVowels(String string) {
        String string2 = string;
        string2 = StringUtil.replaceAll(string, " a", "!~b");
        string2 = StringUtil.replaceAll(string, " e", "!~f");
        string2 = StringUtil.replaceAll(string, " i", "!~j");
        string2 = StringUtil.replaceAll(string, " o", "!~p");
        string2 = StringUtil.replaceAll(string, " u", "!~v");
        string2 = StringUtil.replaceAll(string, " A", "!~B");
        string2 = StringUtil.replaceAll(string, " E", "!~F");
        string2 = StringUtil.replaceAll(string, " I", "!~J");
        string2 = StringUtil.replaceAll(string, " O", "!~P");
        string2 = StringUtil.replaceAll(string, " U", "!~V");
        return string2;
    }

    private static String decodeStartingVowels(String string) {
        String string2 = string;
        string2 = StringUtil.replaceAll(string, "!~b", " a");
        string2 = StringUtil.replaceAll(string, "!~f", " e");
        string2 = StringUtil.replaceAll(string, "!~j", " i");
        string2 = StringUtil.replaceAll(string, "!~p", " o");
        string2 = StringUtil.replaceAll(string, "!~v", " u");
        string2 = StringUtil.replaceAll(string, "!~B", " A");
        string2 = StringUtil.replaceAll(string, "!~F", " E");
        string2 = StringUtil.replaceAll(string, "!~J", " I");
        string2 = StringUtil.replaceAll(string, "!~P", " O");
        string2 = StringUtil.replaceAll(string, "!~V", " U");
        return string2;
    }

    public static String escapeHTML(String string) {
        StringUtil.replace(string, "\r\n", "\n", true);
        StringUtil.replace(string, "\n\r", "\n", true);
        StringUtil.replace(string, "\r", "\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("<BR>");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String currentMethodName() {
        StringWriter stringWriter = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        int n = string.indexOf("at");
        n = string.indexOf("at", n + 1);
        int n2 = string.indexOf("(", n);
        return string.substring(n + 3, n2);
    }
}

