/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jtstest.testrunner.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class GuiUtil {
    public static void center(Component component, Component component2) {
        Dimension dimension = component2.getSize();
        component.setLocation(component2.getX() + (dimension.width - component.getWidth()) / 2, component2.getY() + (dimension.height - component.getHeight()) / 2);
    }

    public static void centerOnScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation((dimension.width - component.getWidth()) / 2, (dimension.height - component.getHeight()) / 2);
    }

    public static void centerOnWindow(Component component) {
        GuiUtil.center(component, SwingUtilities.windowForComponent(component));
    }

    public static void commitChanges(JTable jTable) {
        if (jTable.isEditing()) {
            String string = ((JTextComponent)jTable.getEditorComponent()).getText();
            jTable.setValueAt(string, jTable.getEditingRow(), jTable.getEditingColumn());
            jTable.getCellEditor().cancelCellEditing();
        }
    }

    public static void show(JInternalFrame jInternalFrame, JDesktopPane jDesktopPane) throws PropertyVetoException {
        if (!jDesktopPane.isAncestorOf(jInternalFrame)) {
            jDesktopPane.add(jInternalFrame);
        }
        jInternalFrame.setClosed(false);
        jInternalFrame.setVisible(true);
        jInternalFrame.toFront();
    }

    public static File[] getSelectedFiles(JFileChooser jFileChooser) {
        Object object;
        Object object2 = jFileChooser.getComponent(3);
        JList jList = null;
        while (object2 != null) {
            object = (Container)object2.getComponent(0);
            if (object instanceof JList) {
                jList = (JList)object;
                break;
            }
            object2 = object;
        }
        object = jList.getSelectedValues();
        File[] fileArray = new File[((Object[])object).length];
        for (int i = 0; i < ((Object[])object).length; ++i) {
            if (!(object[i] instanceof File)) continue;
            fileArray[i] = (File)object[i];
        }
        return fileArray;
    }

    public static void formatTooltips(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JComponent) {
                GuiUtil.formatTooltip((JComponent)component);
            }
            if (!(component instanceof Container)) continue;
            GuiUtil.formatTooltips((Container)component);
        }
    }

    public static void formatTooltip(JComponent jComponent) {
        String string = jComponent.getToolTipText();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.toLowerCase().indexOf("<html>") > -1) {
            return;
        }
        string = StringUtil.split(string, 50);
        string = StringUtil.replaceAll(string, "\n", "<p>");
        string = "<html>" + string + "</html>";
        jComponent.setToolTipText(string);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }
}

