/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jtstest.testbuilder.topostretch.GeometryVerticesMover;
import com.vividsolutions.jtstest.testbuilder.topostretch.NearVertex;
import com.vividsolutions.jtstest.testbuilder.topostretch.NearVertexFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TopologyStretcher {
    private double closeTol = 1.0E-5;
    private double stretchDist = 0.1;
    private List inputGeoms = new ArrayList();
    private List linestrings;

    public TopologyStretcher(Geometry geometry) {
        this.inputGeoms.add(geometry);
    }

    public TopologyStretcher(Geometry geometry, Geometry geometry2) {
        this.inputGeoms.add(geometry);
        this.inputGeoms.add(geometry2);
    }

    public List stretch(double d) {
        this.stretchDist = d;
        this.linestrings = this.extractLineStrings(this.inputGeoms);
        List list = NearVertexFinder.findNear(this.linestrings, this.closeTol);
        Map map = this.getCoordinateMovesMap(list);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < this.inputGeoms.size(); ++i) {
            Geometry geometry = (Geometry)this.inputGeoms.get(i);
            Geometry geometry2 = GeometryVerticesMover.move(geometry, map);
            arrayList.add(geometry2);
        }
        return arrayList;
    }

    private List extractLineStrings(List list) {
        ArrayList arrayList = new ArrayList();
        LinearComponentExtracter linearComponentExtracter = new LinearComponentExtracter(arrayList);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            geometry.apply((GeometryComponentFilter)linearComponentExtracter);
        }
        return arrayList;
    }

    private Map getCoordinateMovesMap(List list) {
        TreeMap<Coordinate, Coordinate> treeMap = new TreeMap<Coordinate, Coordinate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NearVertex nearVertex = (NearVertex)iterator.next();
            treeMap.put(nearVertex.getVertexCoordinate(), nearVertex.getStretchedVertex(this.stretchDist));
        }
        return treeMap;
    }
}

