/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;

public class NearVertex {
    private Coordinate vertexPt;
    private Coordinate[] parentLine;
    private int index;
    private Coordinate nearPt = null;
    private LineSegment nearSeg = null;
    private Coordinate stretchedPt = null;

    public NearVertex(Coordinate coordinate, Coordinate[] coordinateArray, int n, Coordinate coordinate2) {
        this.vertexPt = coordinate;
        this.parentLine = coordinateArray;
        this.index = n;
        this.nearPt = coordinate2;
    }

    public NearVertex(Coordinate coordinate, Coordinate[] coordinateArray, int n, LineSegment lineSegment) {
        this.vertexPt = coordinate;
        this.parentLine = coordinateArray;
        this.index = n;
        this.nearSeg = lineSegment;
    }

    public Coordinate getVertexCoordinate() {
        return this.vertexPt;
    }

    public Coordinate getStretchedVertex(double d) {
        if (this.stretchedPt != null) {
            return this.stretchedPt;
        }
        this.stretchedPt = this.nearPt != null ? this.getDisplacedFromPoint(d) : this.getDisplacedFromSeg(d);
        return this.stretchedPt;
    }

    private Coordinate getDisplacedFromPoint(double d) {
        LineSegment lineSegment = new LineSegment(this.nearPt, this.vertexPt);
        double d2 = lineSegment.getLength();
        double d3 = (d + d2) / d2;
        Coordinate coordinate = lineSegment.pointAlong(d3);
        return coordinate;
    }

    private Coordinate getDisplacedFromSeg(double d) {
        double d2 = this.nearSeg.projectionFactor(this.vertexPt);
        int n = this.nearSeg.orientationIndex(this.vertexPt);
        if (n == -1) {
            d = -d;
        }
        return this.nearSeg.pointAlongOffset(d2, d);
    }
}

