/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.Result;
import com.vividsolutions.jtstest.testrunner.SimpleReportWriter;
import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestCase;
import java.util.Arrays;
import java.util.Iterator;

public class TestRunnerTestCaseAdapter
implements Testable {
    private TestCase testCase;
    private boolean ranAtLeastOnce = false;
    private WKTWriter wktWriter = new WKTWriter();

    public TestRunnerTestCaseAdapter(TestCase testCase) {
        this.testCase = testCase;
    }

    public void setGeometry(int n, Geometry geometry) {
        if (n == 0) {
            this.testCase.setGeometryA(geometry);
        } else if (n == 1) {
            this.testCase.setGeometryB(geometry);
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public void setIntersectionMatrix(IntersectionMatrix intersectionMatrix) {
    }

    public void setName(String string) {
        this.testCase.setDescription(string);
    }

    public void setExpectedIntersectionMatrix(String string) {
        this.getOrCreateABTest("relate").setArgument(1, string);
    }

    public void setExpectedConvexHull(Geometry geometry) {
        this.setExpectedSpatialFunction("convexhull", geometry);
    }

    public void setExpectedBoundary(Geometry geometry) {
        this.setExpectedSpatialFunction("getboundary", geometry);
    }

    public void setExpectedIntersection(Geometry geometry) {
        this.setExpectedSpatialFunction("intersection", geometry);
    }

    public void setExpectedUnion(Geometry geometry) {
        this.setExpectedSpatialFunction("union", geometry);
    }

    public void setExpectedDifference(Geometry geometry) {
        this.setExpectedSpatialFunction("difference", geometry);
    }

    public void setExpectedSymDifference(Geometry geometry) {
        this.setExpectedSpatialFunction("symdifference", geometry);
    }

    public void setExpectedCentroid(Geometry geometry) {
        this.setExpectedSpatialFunction("centroid", geometry);
    }

    public boolean isFailed() {
        if (!this.ranAtLeastOnce) {
            return false;
        }
        Iterator iterator = this.testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            if (test.isPassed()) continue;
            return true;
        }
        return false;
    }

    public String getFailedMsg() {
        if (!this.ranAtLeastOnce) {
            return "";
        }
        Iterator iterator = this.testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            if (test.isPassed()) continue;
            SimpleReportWriter simpleReportWriter = new SimpleReportWriter(false);
            return simpleReportWriter.write(test);
        }
        return "";
    }

    public String getName() {
        return this.testCase.getDescription();
    }

    public Geometry getGeometry(int n) {
        if (n == 0) {
            return this.testCase.getGeometryA();
        }
        if (n == 1) {
            return this.testCase.getGeometryB();
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public IntersectionMatrix getIntersectionMatrix() {
        return this.testCase.getGeometryA().relate(this.testCase.getGeometryB());
    }

    public String getDescription() {
        return this.testCase.getDescription();
    }

    public boolean isPassed() {
        if (!this.ranAtLeastOnce) {
            return false;
        }
        Iterator iterator = this.testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            if (test.isPassed()) continue;
            return false;
        }
        return true;
    }

    public String getWellKnownText(int n) {
        if (n == 0) {
            if (this.testCase.getGeometryA() == null) {
                return null;
            }
            return this.wktWriter.write(this.testCase.getGeometryA());
        }
        if (n == 1) {
            if (this.testCase.getGeometryB() == null) {
                return null;
            }
            return this.wktWriter.write(this.testCase.getGeometryB());
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public TestCase getTestRunnerTestCase() {
        return this.testCase;
    }

    public String getExpectedIntersectionMatrix() {
        Test test = this.getABTest("relate");
        if (test == null) {
            return null;
        }
        return test.getArgument(1);
    }

    public Geometry getExpectedConvexHull() {
        return this.toGeometry(this.getABTest("convexhull"));
    }

    public Geometry getExpectedBoundary() {
        return this.toGeometry(this.getABTest("getboundary"));
    }

    public Geometry getExpectedIntersection() {
        return this.toGeometry(this.getABTest("intersection"));
    }

    public Geometry getExpectedUnion() {
        return this.toGeometry(this.getABTest("union"));
    }

    public Geometry getExpectedDifference() {
        return this.toGeometry(this.getABTest("difference"));
    }

    public Geometry getExpectedSymDifference() {
        return this.toGeometry(this.getABTest("symdifference"));
    }

    public void runTest() throws ParseException {
        this.ranAtLeastOnce = true;
        this.testCase.run();
    }

    public void initGeometry() throws ParseException {
    }

    public Geometry toGeometry(Test test) {
        if (test == null) {
            return null;
        }
        Assert.isTrue((boolean)(test.getExpectedResult() instanceof GeometryResult));
        return ((GeometryResult)test.getExpectedResult()).getGeometry();
    }

    private void setExpectedSpatialFunction(String string, Geometry geometry) {
        if (geometry == null) {
            this.getOrCreateABTest(string).getTestCase().remove(this.getOrCreateABTest(string));
            return;
        }
        this.getOrCreateABTest(string).setResult(new GeometryResult(geometry));
    }

    private Test getOrCreateABTest(String string) {
        Test test = this.getABTest(string);
        if (test == null) {
            test = new Test(this.testCase, this.maxTestIndex(this.testCase) + 1, null, string, "A", Arrays.asList("B"), this.getDefaultResult(string), 0.0);
            this.testCase.add(test);
        }
        return test;
    }

    private Result getDefaultResult(String string) {
        if (GeometryMethodOperation.isBooleanFunction(string)) {
            return new BooleanResult(true);
        }
        if (GeometryMethodOperation.isGeometryFunction(string)) {
            return new GeometryResult((Geometry)new GeometryFactory(this.testCase.getTestRun().getPrecisionModel(), 0).createGeometryCollection(null));
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    private Test getABTest(String string) {
        Assert.isTrue((GeometryMethodOperation.isBooleanFunction(string) || GeometryMethodOperation.isGeometryFunction(string) ? 1 : 0) != 0);
        Iterator iterator = this.testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            if (!test.getOperation().equalsIgnoreCase(string) || string.equalsIgnoreCase("relate") && !test.getExpectedResult().equals(new BooleanResult(true)) || !test.getGeometryIndex().equalsIgnoreCase("A") || test.getArgumentCount() != 0 && (test.getArgument(0) == null || !test.getArgument(0).equalsIgnoreCase("B"))) continue;
            return test;
        }
        return null;
    }

    private int maxTestIndex(TestCase testCase) {
        int n = -1;
        Iterator iterator = testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            n = Math.max(n, test.getTestIndex());
        }
        return n;
    }
}

