/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import java.awt.geom.Point2D;

public class DrawingGrid {
    public static int DEFAULT_GRID_SIZE = 10;
    public static final int GRID_MAJOR_FACTOR = 1;
    private double gridSize = DEFAULT_GRID_SIZE;
    private int numGridUnits;

    public DrawingGrid(int n) {
        this.setGridSize(n);
    }

    public DrawingGrid() {
        this(DEFAULT_GRID_SIZE);
    }

    public Point2D snapToGrid(Point2D point2D) {
        return this.snapToGrid(point2D, 1);
    }

    public Point2D snapToMajorGrid(Point2D point2D) {
        return this.snapToGrid(point2D, 1);
    }

    public Point2D snapToGrid(Point2D point2D, int n) {
        double d;
        double d2;
        int n2 = n * this.numGridUnits;
        if (this.isFractional()) {
            d2 = Math.floor(point2D.getX() * (double)n2 + 0.5) / (double)n2;
            d = Math.floor(point2D.getY() * (double)n2 + 0.5) / (double)n2;
        } else {
            d2 = Math.floor(point2D.getX() / (double)n2 + 0.5) * (double)n2;
            d = Math.floor(point2D.getY() / (double)n2 + 0.5) * (double)n2;
        }
        return new Point2D.Double(d2, d);
    }

    public void setGridSize(double d) {
        this.gridSize = d;
        this.numGridUnits = (int)Math.floor(d);
        if (this.isFractional()) {
            this.numGridUnits = (int)Math.floor(1.0 / d);
        }
    }

    public boolean isFractional() {
        return this.gridSize < 1.0;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public boolean isResolvable(Point2D point2D, Point2D point2D2) {
        return point2D2.getX() - point2D.getX() < this.getGridSize();
    }
}

