/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class GeometryVertexDeleter {
    public static Geometry delete(Geometry geometry, LineString lineString, int n) {
        GeometryEditor geometryEditor = new GeometryEditor();
        return geometryEditor.edit(geometry, (GeometryEditor.GeometryEditorOperation)new DeleteVertexOperation(lineString, n));
    }

    private static class DeleteVertexOperation
    extends GeometryEditor.CoordinateOperation {
        private LineString line;
        private int vertexIndex;
        private Coordinate newVertex;

        public DeleteVertexOperation(LineString lineString, int n) {
            this.line = lineString;
            this.vertexIndex = n;
        }

        public Coordinate[] edit(Coordinate[] coordinateArray, Geometry geometry) {
            if (geometry != this.line) {
                return coordinateArray;
            }
            int n = 2;
            if (geometry instanceof LinearRing) {
                n = 4;
            }
            if (coordinateArray.length <= n) {
                return coordinateArray;
            }
            int n2 = coordinateArray.length - 1;
            Coordinate[] coordinateArray2 = new Coordinate[n2];
            int n3 = 0;
            for (int i = 0; i < coordinateArray.length; ++i) {
                if (i == this.vertexIndex) continue;
                coordinateArray2[n3] = coordinateArray[i];
                ++n3;
            }
            if (geometry instanceof LinearRing && (coordinateArray2[n2 - 1] == null || !coordinateArray2[n2 - 1].equals2D(coordinateArray2[0]))) {
                coordinateArray2[n2 - 1] = new Coordinate(coordinateArray2[0]);
            }
            return coordinateArray2;
        }
    }
}

