/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestListPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    private DefaultListModel listModel = new DefaultListModel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList list = new JList(this.listModel);
    BorderLayout borderLayout2 = new BorderLayout();

    public TestListPanel(JTSTestBuilderFrame jTSTestBuilderFrame) {
        this();
    }

    public TestListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.list.setCellRenderer(new TestListCellRenderer());
        this.registerListSelectionListener();
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.setLayout(this.borderLayout2);
        this.list.setSelectionMode(0);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }

    private void registerListSelectionListener() {
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TestListPanel.this.list.getSelectedValue() == null) {
                    return;
                }
                JTSTestBuilderFrame.getInstance().setCurrentTestCase((TestCaseEdit)TestListPanel.this.list.getSelectedValue());
            }
        });
    }

    public void populateList() {
        this.listModel.clear();
        Iterator iterator = JTSTestBuilderFrame.getInstance().getTestCases().iterator();
        while (iterator.hasNext()) {
            Testable testable = (Testable)iterator.next();
            this.listModel.addElement(testable);
        }
    }

    private class TestListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private final ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("tickShaded.gif"));
        private final ImageIcon crossIcon = new ImageIcon(this.getClass().getResource("crossShaded.gif"));
        private final ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("clear.gif"));

        private TestListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Testable testable = (Testable)object;
            String string = testable.getName();
            if ((string == null || string.length() == 0) && testable instanceof TestCaseEdit) {
                string = ((TestCaseEdit)testable).getDescription();
            }
            if (string == null || string.length() == 0) {
                string = "";
            }
            int n2 = 1 + JTSTestBuilderFrame.getInstance().getTestCases().indexOf(testable);
            string = string == "" ? "Test " + n2 : "Test " + n2 + ": " + string;
            this.setText(string);
            this.setOpaque(true);
            this.setIcon(testable.isPassed() ? this.tickIcon : (testable.isFailed() ? this.crossIcon : this.clearIcon));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }
}

