/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PrecisionModelPanel
extends JPanel {
    private PrecisionModel precisionModel;
    JLabel jLabel1 = new JLabel();
    JTextField txtScale = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel4 = new JLabel();
    JRadioButton rbFixed = new JRadioButton();
    JRadioButton rbFloating = new JRadioButton();
    ButtonGroup btnGrpmodelType = new ButtonGroup();
    private JRadioButton rbFloatingSingle = new JRadioButton();

    public PrecisionModelPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Scale");
        this.setLayout(this.gridBagLayout1);
        this.txtScale.setBackground(Color.white);
        this.txtScale.setToolTipText("");
        this.txtScale.setText("1.0");
        this.txtScale.setHorizontalAlignment(4);
        this.setMinimumSize(new Dimension(300, 200));
        this.setPreferredSize(new Dimension(300, 200));
        this.setToolTipText("");
        this.jLabel4.setForeground(SystemColor.desktop);
        this.jLabel4.setToolTipText("");
        this.jLabel4.setText("Set the Precision Model for all Test Cases");
        this.rbFixed.setToolTipText(" * <li>FLOATING - represents full double precision floating point.\n * This is the default precision model used in JTS\n");
        this.rbFixed.setText("Fixed");
        this.rbFixed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrecisionModelPanel.this.rbFixed_actionPerformed(actionEvent);
            }
        });
        this.rbFloating.setText("Floating (Double)");
        this.rbFloating.setToolTipText("");
        this.rbFloating.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrecisionModelPanel.this.rbFloating_actionPerformed(actionEvent);
            }
        });
        this.rbFloatingSingle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrecisionModelPanel.this.rbFloatingSingle_actionPerformed(actionEvent);
            }
        });
        this.rbFloatingSingle.setToolTipText("");
        this.rbFloatingSingle.setText("Floating (Single)");
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 1, 1, 0.2, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)this.txtScale, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.rbFixed, new GridBagConstraints(0, 3, 2, 1, 0.2, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.rbFloating, new GridBagConstraints(0, 1, 2, 1, 0.2, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.rbFloatingSingle, new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.btnGrpmodelType.add(this.rbFloating);
        this.btnGrpmodelType.add(this.rbFixed);
        this.btnGrpmodelType.add(this.rbFloatingSingle);
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
        PrecisionModel.Type type = precisionModel.getType();
        this.rbFixed.setSelected(type == PrecisionModel.FIXED);
        this.rbFloating.setSelected(type == PrecisionModel.FLOATING);
        this.rbFloatingSingle.setSelected(type == PrecisionModel.FLOATING_SINGLE);
        if (type == PrecisionModel.FIXED) {
            this.txtScale.setText(Double.toString(precisionModel.getScale()));
        }
        this.updateDisplay();
    }

    public PrecisionModel getPrecisionModel() {
        if (this.rbFloating.isSelected()) {
            return new PrecisionModel();
        }
        if (this.rbFloatingSingle.isSelected()) {
            return new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
        }
        double d = Double.parseDouble(this.txtScale.getText());
        return new PrecisionModel(d);
    }

    void updateDisplay() {
        if (this.isFloatingSelected()) {
            this.txtScale.setEnabled(false);
            this.txtScale.setForeground(Color.lightGray);
            this.txtScale.setBackground(Color.lightGray);
        } else {
            this.txtScale.setEnabled(true);
            this.txtScale.setForeground(Color.black);
            this.txtScale.setBackground(Color.white);
        }
    }

    boolean isFloatingSelected() {
        return this.rbFloating.isSelected() || this.rbFloatingSingle.isSelected();
    }

    void rbFloating_actionPerformed(ActionEvent actionEvent) {
        this.updateDisplay();
    }

    void rbFixed_actionPerformed(ActionEvent actionEvent) {
        this.updateDisplay();
    }

    void rbFloatingSingle_actionPerformed(ActionEvent actionEvent) {
        this.updateDisplay();
    }
}

