/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.DrawingGrid;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.GeometryLocationsWriter;
import com.vividsolutions.jtstest.testbuilder.ui.render.AWTUtil;
import com.vividsolutions.jtstest.testbuilder.ui.render.GridRenderer;
import com.vividsolutions.jtstest.testbuilder.ui.tools.CreationTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.EditVertexTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GeometryEditPanel
extends JPanel {
    private static double HIGHLIGHT_SIZE = 50.0;
    private static Color HIGHLIGHT_COLOR = new Color(255, 192, 0, 150);
    private static Color[] selectedPointColor = new Color[]{new Color(0, 64, 128, 255), new Color(170, 64, 0, 255)};
    private TestBuilderModel model;
    private GeometryEditModel geomModel;
    private DrawingGrid grid = new DrawingGrid();
    private GridRenderer gridRenderer;
    boolean stateAddingPoints = false;
    Coordinate highlightPoint;
    Point2D lastPt = new Point2D.Double();
    private Tool currentTool = CreationTool.getInstance();
    private Viewport viewport = new Viewport(this);
    BorderLayout borderLayout1 = new BorderLayout();

    public GeometryEditPanel() {
        this.gridRenderer = new GridRenderer(this.viewport, this.grid);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setToolTipText("");
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.model = testBuilderModel;
        this.geomModel = testBuilderModel.getGeometryEditModel();
    }

    public TestBuilderModel getModel() {
        return this.model;
    }

    public void setGridEnabled(boolean bl) {
        this.gridRenderer.setEnabled(bl);
    }

    public GeometryEditModel getGeomModel() {
        return this.model.getGeometryEditModel();
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void updateView() {
        this.forceRepaint();
    }

    public void forceRepaint() {
        Container container = SwingUtilities.windowForComponent(this);
        if (container == null) {
            container = this;
        }
        container.repaint();
    }

    private LayerList getLayerList() {
        return this.model.getLayers();
    }

    public void setShowingInput(boolean bl) {
        if (this.model == null) {
            return;
        }
        this.getLayerList().getLayer(0).setEnabled(bl);
        this.getLayerList().getLayer(1).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingGeometryA(boolean bl) {
        if (this.model == null) {
            return;
        }
        this.getLayerList().getLayer(0).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingGeometryB(boolean bl) {
        if (this.model == null) {
            return;
        }
        this.getLayerList().getLayer(1).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingResult(boolean bl) {
        if (this.model == null) {
            return;
        }
        this.getLayerList().getLayer(2).setEnabled(bl);
        this.forceRepaint();
    }

    public void setGridSize(double d) {
        this.grid.setGridSize(d);
        this.forceRepaint();
    }

    public void setHighlightPoint(Coordinate coordinate) {
        this.highlightPoint = coordinate;
    }

    public boolean isAddingPoints() {
        return this.stateAddingPoints;
    }

    public void updateGeom() {
        this.geomModel.geomChanged();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Coordinate coordinate = this.viewport.toModelCoordinate(mouseEvent.getPoint());
        double d = (double)EditVertexTool.TOLERANCE_PIXELS / this.getViewport().getScale();
        return GeometryLocationsWriter.writeLocation(this.getLayerList(), coordinate, d);
    }

    public double getGridSize() {
        return this.grid.getGridSize();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gridRenderer.paint(graphics2D);
        this.getLayerList().paint(graphics2D, this.getViewport());
        this.drawHighlight(graphics2D);
    }

    private void drawHighlight(Graphics2D graphics2D) {
        if (this.highlightPoint == null) {
            return;
        }
        double d = HIGHLIGHT_SIZE;
        Point2D point2D = this.viewport.toView(this.highlightPoint);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        Ellipse2D.Double double_ = new Ellipse2D.Double(d2 - d / 2.0, d3 - d / 2.0, d, d);
        AWTUtil.setStroke(graphics2D, 4.0);
        graphics2D.setColor(HIGHLIGHT_COLOR);
        graphics2D.draw(double_);
    }

    public Point2D snapToGrid(Point2D point2D) {
        return this.grid.snapToGrid(point2D);
    }

    void jbInit() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GeometryEditPanel.this.this_componentResized(componentEvent);
            }
        });
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                GeometryEditPanel.this.this_mouseMoved(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GeometryEditPanel.this.this_mouseClicked(mouseEvent);
            }
        });
        this.setLayout(this.borderLayout1);
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.viewport.update();
    }

    public void setCurrentTool(Tool tool) {
        this.removeMouseListener(this.currentTool);
        this.removeMouseMotionListener(this.currentTool);
        this.currentTool = tool;
        tool.activate();
        this.setCursor(tool.getCursor());
        this.addMouseListener(tool);
        this.addMouseMotionListener(tool);
    }

    public void zoomToFullExtent() {
        Envelope envelope = this.geomModel.getEnvelope();
        if (envelope.isNull()) {
            this.viewport.zoomToInitialExtent();
            return;
        }
        double d = (envelope.getWidth() + envelope.getHeight()) / 2.0;
        double d2 = Math.max(10.0, d * 0.03);
        envelope.expandToInclude(envelope.getMaxX() + d2, envelope.getMaxY() + d2);
        envelope.expandToInclude(envelope.getMinX() - d2, envelope.getMinY() - d2);
        this.viewport.zoom(envelope);
    }
}

