/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.test.Testable;

public class TestCase
implements Testable {
    private PrecisionModel pm = new PrecisionModel();
    private WKTWriter wktWriter = new WKTWriter();
    protected String name;
    protected String description;
    protected String expectedIM;
    protected boolean isRun = false;
    protected boolean failed = false;
    protected String failedMsg = "";
    private Geometry expectedConvexHull = null;
    private Geometry expectedBoundary = null;
    private Geometry expectedIntersection = null;
    private Geometry expectedUnion = null;
    private Geometry expectedDifference = null;
    private Geometry expectedSymDifference = null;
    private Geometry expectedCentroid = null;
    private IntersectionMatrix im;
    private Geometry[] geom = new Geometry[2];
    private String wkta;
    private String wktb;

    public TestCase() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public TestCase(String string) {
        this(string, null, null, null, null, null, null, null, null, null);
    }

    public TestCase(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5, null, null, null, null, null);
    }

    public TestCase(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, null);
    }

    public TestCase(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        try {
            this.init(string, string2, string3, string4, string5, this.toNullOrGeometry(string6), this.toNullOrGeometry(string7), this.toNullOrGeometry(string8), this.toNullOrGeometry(string9), this.toNullOrGeometry(string10), this.toNullOrGeometry(string11));
        }
        catch (ParseException parseException) {
            Assert.shouldNeverReachHere();
        }
    }

    public TestCase(TestCase testCase) {
        this.init(testCase.name, testCase.description, testCase.getWellKnownText(0), testCase.getWellKnownText(1), testCase.expectedIM, testCase.getExpectedConvexHull(), testCase.getExpectedIntersection(), testCase.getExpectedUnion(), testCase.getExpectedDifference(), testCase.getExpectedSymDifference(), testCase.getExpectedBoundary());
    }

    public void setGeometry(int n, Geometry geometry) {
        this.geom[n] = geometry;
    }

    public TestCase setPrecisionModel(PrecisionModel precisionModel) {
        this.pm = precisionModel;
        return this;
    }

    public void setIntersectionMatrix(IntersectionMatrix intersectionMatrix) {
        this.im = intersectionMatrix;
    }

    public void setExpectedIntersectionMatrix(String string) {
        this.expectedIM = string;
    }

    public TestCase setExpectedRelateMatrix(String string) {
        this.expectedIM = string;
        return this;
    }

    public TestCase setTestName(String string) {
        this.name = string;
        return this;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setExpectedConvexHull(Geometry geometry) {
        this.expectedConvexHull = geometry;
    }

    public void setExpectedBoundary(Geometry geometry) {
        this.expectedBoundary = geometry;
    }

    public void setExpectedIntersection(Geometry geometry) {
        this.expectedIntersection = geometry;
    }

    public void setExpectedUnion(Geometry geometry) {
        this.expectedUnion = geometry;
    }

    public void setExpectedDifference(Geometry geometry) {
        this.expectedDifference = geometry;
    }

    public void setExpectedSymDifference(Geometry geometry) {
        this.expectedSymDifference = geometry;
    }

    public void setExpectedCentroid(Geometry geometry) {
        this.expectedCentroid = geometry;
    }

    public TestCase setExpectedIntersection(String string) {
        try {
            this.expectedIntersection = this.toNullOrGeometry(string);
        }
        catch (ParseException parseException) {
            Assert.shouldNeverReachHere();
        }
        return this;
    }

    public TestCase setExpectedBoundary(String string) {
        try {
            this.expectedBoundary = this.toNullOrGeometry(string);
        }
        catch (ParseException parseException) {
            Assert.shouldNeverReachHere();
        }
        return this;
    }

    public TestCase setA(String string) {
        this.wkta = string;
        return this;
    }

    public TestCase setB(String string) {
        this.wktb = string;
        return this;
    }

    public Geometry getGeometry(int n) {
        return this.geom[n];
    }

    public IntersectionMatrix getIntersectionMatrix() {
        return this.im;
    }

    public String getExpectedIntersectionMatrix() {
        return this.expectedIM;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public boolean isPassed() {
        return this.isRun && !this.failed;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public String getWellKnownText(int n) {
        if (this.geom[n] == null) {
            return null;
        }
        return this.wktWriter.write(this.geom[n]);
    }

    public Geometry getExpectedConvexHull() {
        return this.expectedConvexHull;
    }

    public Geometry getExpectedBoundary() {
        return this.expectedBoundary;
    }

    public Geometry getExpectedIntersection() {
        return this.expectedIntersection;
    }

    public Geometry getExpectedUnion() {
        return this.expectedUnion;
    }

    public Geometry getExpectedDifference() {
        return this.expectedDifference;
    }

    public Geometry getExpectedSymDifference() {
        return this.expectedSymDifference;
    }

    public Geometry[] getGeometries() {
        return this.geom;
    }

    public void runTest() throws ParseException {
        Geometry geometry;
        this.failed = false;
        this.isRun = true;
        this.initGeometry();
        if (this.expectedIM != null) {
            geometry = null;
            if (this.geom[0] != null && this.geom[1] != null) {
                geometry = this.relate(this.geom[0], this.geom[1]);
            }
            if (geometry != null) {
                String string = " expected " + this.expectedIM + ", found " + geometry.toString();
                this.assertTrue(geometry.matches(this.expectedIM), string);
            }
        }
        if (this.expectedBoundary != null) {
            geometry = this.geom[0].getBoundary();
            this.assertEqualsExact(this.expectedBoundary, geometry, " expected boundary " + this.expectedBoundary.toText() + " , found " + geometry.toText());
        }
        if (this.expectedConvexHull != null) {
            geometry = this.geom[0].convexHull();
            this.assertEqualsExact(this.expectedConvexHull, geometry, " expected convex hull " + this.expectedConvexHull.toText() + " , found " + geometry.toText());
        }
        if (this.expectedIntersection != null) {
            geometry = this.geom[0].intersection(this.geom[1]);
            this.assertEqualsExact(this.expectedIntersection, geometry, " expected intersection " + this.expectedIntersection.toText() + " , found " + geometry.toText());
        }
        if (this.expectedUnion != null) {
            geometry = this.geom[0].union(this.geom[1]);
            this.assertEqualsExact(this.expectedUnion, geometry, " expected union " + this.expectedUnion.toText() + " , found " + geometry.toText());
        }
        if (this.expectedDifference != null) {
            geometry = this.geom[0].difference(this.geom[1]);
            this.assertEqualsExact(this.expectedDifference, geometry, " expected difference " + this.expectedDifference.toText() + " , found " + geometry.toText());
        }
        if (this.expectedSymDifference != null) {
            geometry = this.geom[0].symDifference(this.geom[1]);
            this.assertEqualsExact(this.expectedSymDifference, geometry, " expected sym difference " + this.expectedSymDifference.toText() + " , found " + geometry.toText());
        }
    }

    public void initGeometry() throws ParseException {
        GeometryFactory geometryFactory = new GeometryFactory(this.pm, 0);
        WKTReader wKTReader = new WKTReader(geometryFactory);
        if (this.geom[0] != null) {
            return;
        }
        if (this.wkta != null) {
            this.geom[0] = wKTReader.read(this.wkta);
        }
        if (this.wktb != null) {
            this.geom[1] = wKTReader.read(this.wktb);
        }
    }

    void init(String string, String string2, String string3, String string4, String string5, Geometry geometry, Geometry geometry2, Geometry geometry3, Geometry geometry4, Geometry geometry5, Geometry geometry6) {
        this.name = string;
        this.description = string2;
        this.wkta = string3;
        this.wktb = string4;
        this.expectedIM = string5;
        this.expectedConvexHull = geometry;
        this.expectedBoundary = geometry6;
        this.expectedIntersection = geometry2;
        this.expectedUnion = geometry3;
        this.expectedDifference = geometry4;
        this.expectedSymDifference = geometry5;
    }

    IntersectionMatrix relate(Geometry geometry, Geometry geometry2) {
        return geometry.relate(geometry2);
    }

    void assertEquals(Object object, Object object2, String string) {
        this.assertTrue(object.equals(object2), string);
    }

    void assertEqualsExact(Geometry geometry, Geometry geometry2, String string) {
        Geometry geometry3 = (Geometry)geometry.clone();
        Geometry geometry4 = (Geometry)geometry2.clone();
        geometry3.normalize();
        geometry4.normalize();
        this.assertTrue(geometry3.equalsExact(geometry4), string);
    }

    void assertTrue(boolean bl, String string) {
        if (!bl) {
            this.failed = true;
            this.failedMsg = string;
        }
    }

    private Geometry toNullOrGeometry(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(this.pm, 0);
        WKTReader wKTReader = new WKTReader(geometryFactory);
        return wKTReader.read(string);
    }
}

