/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.Result;

public class PreparedGeometryOperation
implements GeometryOperation {
    private GeometryMethodOperation chainOp = new GeometryMethodOperation();

    public PreparedGeometryOperation() {
    }

    public Class getReturnType(String string) {
        if (PreparedGeometryOperation.isPreparedOp(string)) {
            return Boolean.TYPE;
        }
        return this.chainOp.getReturnType(string);
    }

    public PreparedGeometryOperation(GeometryMethodOperation geometryMethodOperation) {
        this.chainOp = geometryMethodOperation;
    }

    private static boolean isPreparedOp(String string) {
        if (string.equals("intersects")) {
            return true;
        }
        if (string.equals("contains")) {
            return true;
        }
        if (string.equals("containsProperly")) {
            return true;
        }
        return string.equals("covers");
    }

    public Result invoke(String string, Geometry geometry, Object[] objectArray) throws Exception {
        if (!PreparedGeometryOperation.isPreparedOp(string)) {
            return this.chainOp.invoke(string, geometry, objectArray);
        }
        return this.invokePreparedOp(string, geometry, objectArray);
    }

    private Result invokePreparedOp(String string, Geometry geometry, Object[] objectArray) {
        Geometry geometry2 = (Geometry)objectArray[0];
        if (string.equals("intersects")) {
            return new BooleanResult(PreparedGeometryOp.intersects(geometry, geometry2));
        }
        if (string.equals("contains")) {
            return new BooleanResult(PreparedGeometryOp.contains(geometry, geometry2));
        }
        if (string.equals("containsProperly")) {
            return new BooleanResult(PreparedGeometryOp.containsProperly(geometry, geometry2));
        }
        if (string.equals("covers")) {
            return new BooleanResult(PreparedGeometryOp.covers(geometry, geometry2));
        }
        return null;
    }

    static class PreparedGeometryOp {
        PreparedGeometryOp() {
        }

        public static boolean intersects(Geometry geometry, Geometry geometry2) {
            PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
            return preparedGeometry.intersects(geometry2);
        }

        public static boolean contains(Geometry geometry, Geometry geometry2) {
            PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
            return preparedGeometry.contains(geometry2);
        }

        public static boolean containsProperly(Geometry geometry, Geometry geometry2) {
            PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
            return preparedGeometry.containsProperly(geometry2);
        }

        public static boolean covers(Geometry geometry, Geometry geometry2) {
            PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
            return preparedGeometry.covers(geometry2);
        }
    }
}

