/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.command;

import com.vividsolutions.jtstest.command.Option;
import com.vividsolutions.jtstest.command.OptionSpec;
import com.vividsolutions.jtstest.command.ParseException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class CommandLine {
    Hashtable optSpecs = new Hashtable();
    Vector optVec = new Vector();
    char optionChar;

    public CommandLine() {
        this('/');
    }

    public CommandLine(char c) {
        this.optionChar = c;
    }

    public void addOptionSpec(OptionSpec optionSpec) {
        String string = optionSpec.getName();
        this.optSpecs.put(string.toLowerCase(), optionSpec);
        this.optVec.add(optionSpec);
    }

    OptionSpec getOptionSpec(String string) {
        if (this.optSpecs.containsKey(string.toLowerCase())) {
            return (OptionSpec)this.optSpecs.get(string.toLowerCase());
        }
        return null;
    }

    public Option getOption(String string) {
        OptionSpec optionSpec = this.getOptionSpec(string);
        if (optionSpec == null) {
            return null;
        }
        return optionSpec.getOption(0);
    }

    public Iterator getOptions(String string) {
        OptionSpec optionSpec = this.getOptionSpec(string);
        return optionSpec.getOptions();
    }

    public boolean hasOption(String string) {
        OptionSpec optionSpec = this.getOptionSpec(string);
        if (optionSpec == null) {
            return false;
        }
        return optionSpec.hasOption();
    }

    void addOption(Option option) {
        String string = option.getName();
        ((OptionSpec)this.optSpecs.get(string.toLowerCase())).addOption(option);
    }

    public void printDoc(PrintStream printStream) {
        OptionSpec optionSpec = null;
        printStream.println("Options:");
        Iterator iterator = this.optVec.iterator();
        while (iterator.hasNext()) {
            optionSpec = (OptionSpec)iterator.next();
            String string = this.optionChar + optionSpec.getName();
            if (optionSpec.getName() == "**FREE_ARGS**") {
                string = "(free)";
            }
            printStream.println("  " + string + " " + optionSpec.getArgDesc() + " - " + optionSpec.getDocDesc());
        }
    }

    public void parse(String[] stringArray) throws ParseException {
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; i += vector.size()) {
            int n;
            String string;
            String string2;
            if (stringArray[i].charAt(0) == this.optionChar) {
                string2 = stringArray[i].substring(1);
                string = "Invalid option: " + stringArray[i];
                n = i + 1;
            } else {
                string2 = "**FREE_ARGS**";
                string = "Invalid option: " + stringArray[i];
                n = i;
            }
            OptionSpec optionSpec = this.getOptionSpec(string2);
            if (optionSpec == null) {
                throw new ParseException(string);
            }
            int n2 = optionSpec.getAllowedArgs();
            this.parseParams(stringArray, vector, n, n2);
            Option option = optionSpec.parse(vector.toArray(new String[0]));
            this.addOption(option);
            ++i;
        }
    }

    void parseParams(String[] stringArray, Vector vector, int n, int n2) {
        vector.clear();
        int n3 = 0;
        int n4 = n2;
        if (n2 == -3) {
            n4 = 1;
        }
        if (n2 == -1) {
            n4 = 999999999;
        }
        if (n2 == -2) {
            n4 = 999999999;
        }
        while (n < stringArray.length && n3 < n4 && stringArray[n].charAt(0) != this.optionChar) {
            vector.addElement(stringArray[n++]);
            ++n3;
        }
    }
}

