/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SubgraphDepthLocater {
    private Collection subgraphs;
    private LineSegment seg = new LineSegment();
    private CGAlgorithms cga = new CGAlgorithms();

    public SubgraphDepthLocater(List subgraphs) {
        this.subgraphs = subgraphs;
    }

    public int getDepth(Coordinate p) {
        List stabbedSegments = this.findStabbedSegments(p);
        if (stabbedSegments.size() == 0) {
            return 0;
        }
        Collections.sort(stabbedSegments);
        DepthSegment ds = (DepthSegment)stabbedSegments.get(0);
        return ds.leftDepth;
    }

    private List findStabbedSegments(Coordinate stabbingRayLeftPt) {
        ArrayList stabbedSegments = new ArrayList();
        Iterator i = this.subgraphs.iterator();
        while (i.hasNext()) {
            BufferSubgraph bsg = (BufferSubgraph)i.next();
            Envelope env = bsg.getEnvelope();
            if (stabbingRayLeftPt.y < env.getMinY() || stabbingRayLeftPt.y > env.getMaxY()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, bsg.getDirectedEdges(), stabbedSegments);
        }
        return stabbedSegments;
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, List dirEdges, List stabbedSegments) {
        Iterator i = dirEdges.iterator();
        while (i.hasNext()) {
            DirectedEdge de = (DirectedEdge)i.next();
            if (!de.isForward()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, de, stabbedSegments);
        }
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, DirectedEdge dirEdge, List stabbedSegments) {
        Coordinate[] pts = dirEdge.getEdge().getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            double maxx;
            this.seg.p0 = pts[i];
            this.seg.p1 = pts[i + 1];
            if (this.seg.p0.y > this.seg.p1.y) {
                this.seg.reverse();
            }
            if ((maxx = Math.max(this.seg.p0.x, this.seg.p1.x)) < stabbingRayLeftPt.x || this.seg.isHorizontal() || stabbingRayLeftPt.y < this.seg.p0.y || stabbingRayLeftPt.y > this.seg.p1.y) continue;
            if (CGAlgorithms.computeOrientation(this.seg.p0, this.seg.p1, stabbingRayLeftPt) == -1) continue;
            int depth = dirEdge.getDepth(1);
            if (!this.seg.p0.equals(pts[i])) {
                depth = dirEdge.getDepth(2);
            }
            DepthSegment ds = new DepthSegment(this.seg, depth);
            stabbedSegments.add(ds);
        }
    }

    private class DepthSegment
    implements Comparable {
        private LineSegment upwardSeg;
        private int leftDepth;

        public DepthSegment(LineSegment seg, int depth) {
            this.upwardSeg = new LineSegment(seg);
            this.leftDepth = depth;
        }

        public int compareTo(Object obj) {
            DepthSegment other = (DepthSegment)obj;
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex == 0) {
                orientIndex = -1 * other.upwardSeg.orientationIndex(this.upwardSeg);
            }
            if (orientIndex != 0) {
                return orientIndex;
            }
            return this.compareX(this.upwardSeg, other.upwardSeg);
        }

        private int compareX(LineSegment seg0, LineSegment seg1) {
            int compare0 = seg0.p0.compareTo(seg1.p0);
            if (compare0 != 0) {
                return compare0;
            }
            return seg0.p1.compareTo(seg1.p1);
        }
    }
}

