/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.gml2.GMLReader;
import com.vividsolutions.jtstest.util.IOUtil;
import java.io.IOException;

public class MultiFormatReader {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_WKT = 1;
    public static final int FORMAT_WKB = 2;
    public static final int FORMAT_GML = 3;
    private static final int MAX_CHARS_TO_CHECK = 6;
    private GeometryFactory geomFactory;
    private WKTReader wktReader;
    private WKBReader wkbReader;

    public static boolean isWKT(String string) {
        return !MultiFormatReader.isWKB(string) && !MultiFormatReader.isGML(string);
    }

    public static boolean isWKB(String string) {
        return MultiFormatReader.isHex(string, 6);
    }

    public static boolean isGML(String string) {
        return string.indexOf("<") >= 0;
    }

    public static int format(String string) {
        if (MultiFormatReader.isWKB(string)) {
            return 2;
        }
        if (MultiFormatReader.isGML(string)) {
            return 3;
        }
        if (MultiFormatReader.isWKT(string)) {
            return 1;
        }
        return 0;
    }

    private static boolean isHex(String string, int n) {
        for (int i = 0; i < n && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (MultiFormatReader.isHexDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigit(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        char c2 = Character.toLowerCase(c);
        return c2 >= 'a' && c2 <= 'f';
    }

    public MultiFormatReader() {
        this(new GeometryFactory());
    }

    public MultiFormatReader(GeometryFactory geometryFactory) {
        this.geomFactory = geometryFactory;
        this.wktReader = new WKTReader(geometryFactory);
        this.wkbReader = new WKBReader(geometryFactory);
    }

    public Geometry read(String string) throws ParseException, IOException {
        String string2 = string.trim();
        if (MultiFormatReader.isWKB(string2)) {
            return IOUtil.readGeometriesFromWKBHexString(string2, this.geomFactory);
        }
        if (MultiFormatReader.isGML(string2)) {
            return this.readGML(string2);
        }
        return IOUtil.readGeometriesFromWKTString(string2, this.geomFactory);
    }

    private Geometry readGML(String string) throws ParseException {
        try {
            return new GMLReader().read(string, this.geomFactory);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage());
        }
    }
}

