/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.style;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.style.Style;
import java.awt.Graphics2D;

public abstract class LineStringStyle
implements Style {
    public static final int LINE = 1;
    public static final int POLY_SHELL = 2;
    public static final int POLY_HOLE = 3;

    public void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D) throws Exception {
        LineString lineString;
        if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
            return;
        }
        if (geometry instanceof LineString) {
            lineString = (LineString)geometry;
            if (lineString.getNumPoints() < 2) {
                return;
            }
            this.paintLineString(lineString, 1, viewport, graphics2D);
        }
        if (geometry instanceof Point) {
            return;
        }
        if (geometry instanceof MultiPoint) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            lineString = (GeometryCollection)geometry;
            for (int i = 0; i < lineString.getNumGeometries(); ++i) {
                this.paint(lineString.getGeometryN(i), viewport, graphics2D);
            }
            return;
        }
        if (geometry instanceof Polygon) {
            lineString = (Polygon)geometry;
            this.paint(lineString.getExteriorRing(), 2, viewport, graphics2D);
            for (int i = 0; i < lineString.getNumInteriorRing(); ++i) {
                this.paint(lineString.getInteriorRingN(i), 3, viewport, graphics2D);
            }
            return;
        }
    }

    public void paint(LineString lineString, int n, Viewport viewport, Graphics2D graphics2D) throws Exception {
        if (!viewport.intersectsInModel(lineString.getEnvelopeInternal())) {
            return;
        }
        this.paintLineString(lineString, n, viewport, graphics2D);
    }

    protected abstract void paintLineString(LineString var1, int var2, Viewport var3, Graphics2D var4) throws Exception;
}

