/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.style;

import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.style.AWTUtil;
import com.vividsolutions.jtstest.testbuilder.ui.style.LineStringEndpointStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class ArrowEndpointStyle
extends LineStringEndpointStyle {
    private static final double ANGLE = 18.0;
    private static final double LENGTH = 15.0;
    private boolean filled = true;
    private Color color = Color.RED;

    public ArrowEndpointStyle(Color color, boolean bl, boolean bl2) {
        super(bl);
        this.color = color;
        this.filled = bl2;
    }

    protected void paint(Point2D point2D, Point2D point2D2, Viewport viewport, Graphics2D graphics2D) throws NoninvertibleTransformException {
        if (point2D.equals(point2D2)) {
            return;
        }
        graphics2D.setPaint(this.color);
        GeneralPath generalPath = ArrowEndpointStyle.arrowheadPath(point2D2, point2D, point2D, 15.0, 18.0);
        if (this.filled) {
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
        graphics2D.draw(generalPath);
    }

    public static GeneralPath arrowheadPath(Point2D point2D, Point2D point2D2, Point2D point2D3, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D4 = ArrowEndpointStyle.fin(point2D3, point2D, d, d2);
        Point2D point2D5 = ArrowEndpointStyle.fin(point2D3, point2D, d, -d2);
        generalPath.moveTo((float)point2D4.getX(), (float)point2D4.getY());
        generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
        generalPath.lineTo((float)point2D5.getX(), (float)point2D5.getY());
        return generalPath;
    }

    public static Point2D fin(Point2D point2D, Point2D point2D2, double d, double d2) {
        double d3 = point2D.distance(point2D2);
        Point2D point2D3 = point2D;
        Point2D point2D4 = AWTUtil.add(AWTUtil.multiply(AWTUtil.subtract(point2D2, point2D), d / d3), point2D3);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2 * Math.PI / 180.0, point2D3.getX(), point2D3.getY());
        return affineTransform.transform(point2D4, null);
    }
}

