/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;

public class VertexLocater {
    private Geometry geom;
    private Coordinate vertexPt;
    private int vertexIndex = -1;

    public static Coordinate locateVertex(Geometry geometry, Coordinate coordinate, double d) {
        VertexLocater vertexLocater = new VertexLocater(geometry);
        return vertexLocater.getVertex(coordinate, d);
    }

    public VertexLocater(Geometry geometry) {
        this.geom = geometry;
    }

    public Coordinate getVertex(Coordinate coordinate, double d) {
        NearestVertexFilter nearestVertexFilter = new NearestVertexFilter(coordinate, d);
        this.geom.apply((CoordinateSequenceFilter)nearestVertexFilter);
        this.vertexPt = nearestVertexFilter.getVertex();
        this.vertexIndex = nearestVertexFilter.getIndex();
        return this.vertexPt;
    }

    public int getIndex() {
        return this.vertexIndex;
    }

    public List getLocations(Coordinate coordinate, double d) {
        NearVerticesFilter nearVerticesFilter = new NearVerticesFilter(coordinate, d);
        this.geom.apply((CoordinateSequenceFilter)nearVerticesFilter);
        return nearVerticesFilter.getLocations();
    }

    public static class Location {
        private Coordinate pt;
        private int[] index;

        Location(Coordinate coordinate, int n) {
            this.pt = coordinate;
            this.index = new int[1];
            this.index[0] = n;
        }

        public Coordinate getCoordinate() {
            return this.pt;
        }

        public int[] getIndices() {
            return this.index;
        }
    }

    static class NearVerticesFilter
    implements CoordinateSequenceFilter {
        private double tolerance = 0.0;
        private Coordinate queryPt;
        private List locations = new ArrayList();

        public NearVerticesFilter(Coordinate coordinate, double d) {
            this.queryPt = coordinate;
            this.tolerance = d;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            double d = coordinate.distance(this.queryPt);
            if (d > this.tolerance) {
                return;
            }
            this.locations.add(new Location(coordinate, n));
        }

        public List getLocations() {
            return this.locations;
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }

    static class NearestVertexFilter
    implements CoordinateSequenceFilter {
        private double tolerance = 0.0;
        private Coordinate basePt;
        private Coordinate nearestPt = null;
        private int vertexIndex = -1;

        public NearestVertexFilter(Coordinate coordinate, double d) {
            this.basePt = coordinate;
            this.tolerance = d;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            double d = coordinate.distance(this.basePt);
            if (d > this.tolerance) {
                return;
            }
            this.nearestPt = coordinate;
            this.vertexIndex = n;
        }

        public Coordinate getVertex() {
            return this.nearestPt;
        }

        public int getIndex() {
            return this.vertexIndex;
        }

        public boolean isDone() {
            return this.nearestPt != null;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

