/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GeometryCombiner {
    private GeometryFactory geomFactory;

    public GeometryCombiner(GeometryFactory geometryFactory) {
        this.geomFactory = geometryFactory;
    }

    public Geometry addPolygonRing(Geometry geometry, Coordinate[] coordinateArray) {
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinateArray);
        if (geometry == null) {
            return this.geomFactory.createPolygon(linearRing, null);
        }
        if (!(geometry instanceof Polygonal)) {
            return this.combine(geometry, (Geometry)this.geomFactory.createPolygon(linearRing, null));
        }
        Polygon polygon = GeometryCombiner.findPolygonContaining(geometry, coordinateArray[0]);
        if (polygon == null) {
            return this.combine(geometry, (Geometry)this.geomFactory.createPolygon(linearRing, null));
        }
        Polygon polygon2 = this.addHole(polygon, linearRing);
        return GeometryCombiner.replace(geometry, (Geometry)polygon, (Geometry)polygon2);
    }

    public Geometry addLineString(Geometry geometry, Coordinate[] coordinateArray) {
        LineString lineString = this.geomFactory.createLineString(coordinateArray);
        return this.combine(geometry, (Geometry)lineString);
    }

    public Geometry addPoint(Geometry geometry, Coordinate coordinate) {
        Point point = this.geomFactory.createPoint(coordinate);
        return this.combine(geometry, (Geometry)point);
    }

    private static Polygon findPolygonContaining(Geometry geometry, Coordinate coordinate) {
        PointLocator pointLocator = new PointLocator();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)geometry.getGeometryN(i);
            int n = pointLocator.locate(coordinate, (Geometry)polygon);
            if (n != 0) continue;
            return polygon;
        }
        return null;
    }

    public Polygon addHole(Polygon polygon, LinearRing linearRing) {
        int n = polygon.getNumInteriorRing();
        LinearRing[] linearRingArray = new LinearRing[n + 1];
        for (int i = 0; i < n; ++i) {
            linearRingArray[i] = (LinearRing)polygon.getInteriorRingN(i);
        }
        linearRingArray[n] = linearRing;
        return this.geomFactory.createPolygon((LinearRing)polygon.getExteriorRing(), linearRingArray);
    }

    public Geometry combine(Geometry geometry, Geometry geometry2) {
        List list = GeometryCombiner.extractElements(geometry, true);
        List list2 = GeometryCombiner.extractElements(geometry2, true);
        list.addAll(list2);
        if (list.size() == 0) {
            return (Geometry)geometry.clone();
        }
        return this.geomFactory.buildGeometry((Collection)list);
    }

    public static List extractElements(Geometry geometry, boolean bl) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        if (geometry == null) {
            return arrayList;
        }
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geometry2 = geometry.getGeometryN(i);
            if (bl && geometry2.isEmpty()) continue;
            arrayList.add(geometry2);
        }
        return arrayList;
    }

    public static Geometry replace(Geometry geometry, Geometry geometry2, Geometry geometry3) {
        List list = GeometryCombiner.extractElements(geometry, false);
        Collections.replaceAll(list, geometry2, geometry3);
        return geometry.getFactory().buildGeometry((Collection)list);
    }
}

