/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jtstest.testbuilder.CoordinateNode;
import com.vividsolutions.jtstest.testbuilder.GeometryNode;

class LineStringNode
extends GeometryNode {
    private LineString line;

    public LineStringNode(LineString lineString) {
        this(lineString, null);
    }

    public LineStringNode(LineString lineString, String string) {
        super((Geometry)lineString, lineString.getNumPoints(), string);
        this.line = lineString;
    }

    public Geometry getGeometry() {
        return this.line;
    }

    protected void fillChildren() {
        this.populateChildren(this.line.getCoordinates());
    }

    private void populateChildren(Coordinate[] coordinateArray) {
        Envelope envelope = this.line.getEnvelopeInternal();
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d = Double.NaN;
            if (i < coordinateArray.length - 1) {
                d = coordinateArray[i].distance(coordinateArray[i + 1]);
            }
            CoordinateNode coordinateNode = CoordinateNode.create(coordinateArray[i], i, d);
            this.children.add(coordinateNode);
        }
    }
}

