/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testbuilder.controller.JTSTestBuilderController;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class LayerCheckBoxList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public LayerCheckBoxList(ListModel listModel) {
        this();
        this.setModel(listModel);
    }

    public LayerCheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = LayerCheckBoxList.this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    Layer layer;
                    layer.setEnabled(!(layer = (Layer)LayerCheckBoxList.this.getModel().getElementAt(n)).isEnabled());
                    LayerCheckBoxList.this.repaint();
                    JTSTestBuilderController.geometryViewChanged();
                }
            }
        });
        this.setSelectionMode(0);
    }

    protected class CellRenderer
    implements ListCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        protected CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Layer layer = (Layer)object;
            this.checkbox.setBackground(bl ? LayerCheckBoxList.this.getSelectionBackground() : LayerCheckBoxList.this.getBackground());
            this.checkbox.setForeground(bl ? LayerCheckBoxList.this.getSelectionForeground() : LayerCheckBoxList.this.getForeground());
            this.checkbox.setSelected(layer.isEnabled());
            this.checkbox.setEnabled(LayerCheckBoxList.this.isEnabled());
            this.checkbox.setFont(LayerCheckBoxList.this.getFont());
            this.checkbox.setFocusPainted(false);
            this.checkbox.setBorderPainted(true);
            this.checkbox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            this.checkbox.setText(layer.getName());
            return this.checkbox;
        }
    }
}

