/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.function.BaseGeometryFunction;
import com.vividsolutions.jtstest.util.ClassUtil;
import com.vividsolutions.jtstest.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class StaticMethodGeometryFunction
extends BaseGeometryFunction {
    private static final String FUNCTIONS_SUFFIX = "Functions";
    private static final String PARAMETERS_SUFFIX = "Parameters";
    private static final String DESCRIPTION_SUFFIX = "Description";
    private Method method;

    public static StaticMethodGeometryFunction createFunction(Method method) {
        Assert.isTrue((boolean)Geometry.class.isAssignableFrom(method.getParameterTypes()[0]));
        Class<?> clazz = method.getDeclaringClass();
        String string = StaticMethodGeometryFunction.extractCategory(ClassUtil.getClassname(clazz));
        String string2 = method.getName();
        String string3 = StaticMethodGeometryFunction.extractDescription(method);
        String[] stringArray = StaticMethodGeometryFunction.extractParamNames(method);
        Class[] classArray = StaticMethodGeometryFunction.extractParamTypes(method);
        Class<?> clazz2 = method.getReturnType();
        return new StaticMethodGeometryFunction(string, string2, string3, stringArray, classArray, clazz2, method);
    }

    private static String extractCategory(String string) {
        String string2 = StringUtil.removeFromEnd(string, FUNCTIONS_SUFFIX);
        return string2;
    }

    private static String[] extractParamNames(Method method) {
        String string = method.getName() + PARAMETERS_SUFFIX;
        String[] stringArray = ClassUtil.getStringArrayClassField(method.getDeclaringClass(), string);
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = new String[method.getParameterTypes().length - 1];
        for (int i = 1; i < stringArray2.length; ++i) {
            stringArray2[i] = "arg" + i;
        }
        return stringArray2;
    }

    private static String extractDescription(Method method) {
        String string = method.getName() + DESCRIPTION_SUFFIX;
        return ClassUtil.getStringClassField(method.getDeclaringClass(), string);
    }

    private static Class[] extractParamTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Class[] classArray2 = new Class[classArray.length - 1];
        for (int i = 1; i < classArray.length; ++i) {
            classArray2[i - 1] = classArray[i];
        }
        return classArray2;
    }

    public StaticMethodGeometryFunction(String string, String string2, String string3, String[] stringArray, Class[] classArray, Class clazz, Method method) {
        super(string, string2, string3, stringArray, classArray, clazz);
        this.method = method;
    }

    public Object invoke(Geometry geometry, Object[] objectArray) {
        return StaticMethodGeometryFunction.invoke(this.method, null, StaticMethodGeometryFunction.createFullArgs(geometry, objectArray));
    }

    private static Object[] createFullArgs(Geometry geometry, Object[] objectArray) {
        int n = 1;
        if (objectArray != null) {
            n = objectArray.length + 1;
        }
        Object[] objectArray2 = new Object[n];
        objectArray2[0] = geometry;
        for (int i = 1; i < n; ++i) {
            objectArray2[i] = objectArray[i - 1];
        }
        return objectArray2;
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) {
        Object object2;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(StaticMethodGeometryFunction.invocationErrMsg(invocationTargetException));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new RuntimeException(exception.getMessage());
        }
        return object2;
    }

    private static String invocationErrMsg(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        String string = StaticMethodGeometryFunction.getClassname(throwable.getClass()) + ": " + throwable.getMessage();
        return string;
    }

    public static String getClassname(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1, string.length());
    }
}

