/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jtstest.testbuilder.AppConstants;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.ui.render.GeometryPainter;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.List;

public class FunctionsUtil {
    public static final Envelope DEFAULT_ENVELOPE = new Envelope(0.0, 100.0, 0.0, 100.0);

    public static Envelope getEnvelopeOrDefault(Geometry geometry) {
        if (geometry == null) {
            return DEFAULT_ENVELOPE;
        }
        return geometry.getEnvelopeInternal();
    }

    public static GeometryFactory getFactoryOrDefault(Geometry geometry) {
        if (geometry == null) {
            return JTSTestBuilder.getGeometryFactory();
        }
        return geometry.getFactory();
    }

    public static void showIndicator(Geometry geometry) {
        GeometryEditPanel geometryEditPanel = JTSTestBuilderFrame.instance().getTestCasePanel().getGeometryEditPanel();
        Graphics2D graphics2D = (Graphics2D)geometryEditPanel.getGraphics();
        GeometryPainter.paint(geometry, geometryEditPanel.getViewport(), graphics2D, AppConstants.INDICATOR_LINE_CLR, AppConstants.INDICATOR_FILL_CLR);
    }

    public static Geometry buildGeometry(List list, Geometry geometry) {
        if (list.size() <= 0) {
            return null;
        }
        if (list.size() == 1) {
            return (Geometry)list.get(0);
        }
        if (geometry.getGeometryType().equals("GeometryCollection")) {
            return geometry.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray((Collection)list));
        }
        return geometry.getFactory().buildGeometry((Collection)list);
    }
}

