/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTFileReader;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.Shapefile;
import com.vividsolutions.jtstest.util.FileUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IOUtil {
    public static Geometry readMultipleGeometriesFromFile(String string, GeometryFactory geometryFactory) throws Exception, IOException {
        String string2 = FileUtil.extension(string);
        if (string2.equalsIgnoreCase(".shp")) {
            return IOUtil.readMultipleGeometriesFromShapefile(string, geometryFactory);
        }
        if (string2.equalsIgnoreCase(".wkb")) {
            return IOUtil.readMultipleGeometriesFromWKBHex(string, geometryFactory);
        }
        return IOUtil.readMultipleGeometryFromWKT(string, geometryFactory);
    }

    private static Geometry readMultipleGeometriesFromShapefile(String string, GeometryFactory geometryFactory) throws Exception {
        Geometry geometry;
        Shapefile shapefile = new Shapefile(new FileInputStream(string));
        shapefile.readStream(geometryFactory);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        while ((geometry = shapefile.next()) != null) {
            arrayList.add(geometry);
        }
        return geometryFactory.createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
    }

    private static Geometry readMultipleGeometriesFromWKBHex(String string, GeometryFactory geometryFactory) throws ParseException, IOException {
        return IOUtil.readGeometryFromWKBHexString(FileUtil.readText(string), geometryFactory);
    }

    private static Geometry readGeometryFromWKBHexString(String string, GeometryFactory geometryFactory) throws ParseException, IOException {
        WKBReader wKBReader = new WKBReader(geometryFactory);
        String string2 = IOUtil.cleanHex(string);
        return wKBReader.read(WKBReader.hexToBytes((String)string2));
    }

    private static String cleanHex(String string) {
        return string.replaceAll("[^0123456789ABCDEFabcdef]", "");
    }

    private static Geometry readMultipleGeometryFromWKT(String string, GeometryFactory geometryFactory) throws ParseException, IOException {
        return IOUtil.readMultipleGeometryFromWKTString(FileUtil.readText(string), geometryFactory);
    }

    private static Geometry readMultipleGeometryFromWKTString(String string, GeometryFactory geometryFactory) throws ParseException, IOException {
        WKTReader wKTReader = new WKTReader(geometryFactory);
        WKTFileReader wKTFileReader = new WKTFileReader((Reader)new StringReader(string), wKTReader);
        List list = wKTFileReader.read();
        if (list.size() == 1) {
            return (Geometry)list.get(0);
        }
        return geometryFactory.buildGeometry((Collection)list);
    }
}

