/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testrunner.EqualityResultMatcher;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.Result;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;

public class BufferResultMatcher
implements ResultMatcher {
    private ResultMatcher defaultMatcher = new EqualityResultMatcher();
    private static final double MAX_RELATIVE_AREA_DIFFERENCE = 0.001;
    private static final double MAX_HAUSDORFF_DISTANCE_FACTOR = 100.0;
    private static final double MIN_DISTANCE_TOLERANCE = 1.0E-8;

    public boolean isMatch(Geometry geometry, String string, Object[] objectArray, Result result, Result result2, double d) {
        if (!string.equalsIgnoreCase("buffer")) {
            return this.defaultMatcher.isMatch(geometry, string, objectArray, result, result2, d);
        }
        double d2 = Double.parseDouble((String)objectArray[0]);
        return this.isBufferResultMatch(((GeometryResult)result).getGeometry(), ((GeometryResult)result2).getGeometry(), d2);
    }

    public boolean isBufferResultMatch(Geometry geometry, Geometry geometry2, double d) {
        if (geometry.isEmpty() && geometry2.isEmpty()) {
            return true;
        }
        if (!this.isSymDiffAreaInTolerance(geometry, geometry2)) {
            return false;
        }
        return this.isBoundaryHausdorffDistanceInTolerance(geometry, geometry2, d);
    }

    public boolean isSymDiffAreaInTolerance(Geometry geometry, Geometry geometry2) {
        double d = geometry2.getArea();
        Geometry geometry3 = geometry.symDifference(geometry2);
        double d2 = geometry3.getArea();
        if (d2 <= 0.0) {
            return true;
        }
        double d3 = Double.POSITIVE_INFINITY;
        if (d > 0.0) {
            d3 = d2 / d;
        }
        return d3 < 0.001;
    }

    public boolean isBoundaryHausdorffDistanceInTolerance(Geometry geometry, Geometry geometry2, double d) {
        Geometry geometry3 = geometry.getBoundary();
        Geometry geometry4 = geometry2.getBoundary();
        DiscreteHausdorffDistance discreteHausdorffDistance = new DiscreteHausdorffDistance(geometry3, geometry4);
        discreteHausdorffDistance.setDensifyFraction(0.25);
        double d2 = discreteHausdorffDistance.orientedDistance();
        double d3 = Math.abs(d) / 100.0;
        if (d3 < 1.0E-8) {
            d3 = 1.0E-8;
        }
        return !(d2 > d3);
    }
}

