/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.topostretch.TopologyStretcher;
import java.util.List;

public class GeometryStretcherView {
    private static final int MAX_VERTICES_IN_MASK = 500;
    public static final double NEARNESS_TOL_IN_VIEW = 1.0;
    private GeometryEditModel geomModel;
    private Geometry[] stretchGeom = new Geometry[2];
    private List[] stretchCoords;
    private boolean isViewPerformant = true;
    private Envelope maskEnv = null;
    private double stretchSize = 5.0;
    private double nearnessTol = 0.5;

    public GeometryStretcherView(GeometryEditModel geometryEditModel) {
        this.geomModel = geometryEditModel;
    }

    public GeometryContainer getContainer(int n) {
        return new StretchedGeometryContainer(n);
    }

    public void setStretchSize(double d) {
        this.stretchSize = d;
    }

    public void setNearnessTolerance(double d) {
        this.nearnessTol = d;
    }

    public void setEnvelope(Envelope envelope) {
        this.maskEnv = envelope;
        this.stretchGeom = null;
    }

    public boolean isViewPerformant() {
        this.updateCache();
        return this.isViewPerformant;
    }

    public Geometry getStretchedGeometry(int n) {
        this.updateCache();
        return this.stretchGeom[n];
    }

    public List getStretchedVertices(int n) {
        this.updateCache();
        return this.stretchCoords[n];
    }

    private synchronized void updateCache() {
        if (!this.isCacheValid()) {
            Geometry geometry = this.geomModel.getGeometry(0);
            Geometry geometry2 = this.geomModel.getGeometry(1);
            TopologyStretcher topologyStretcher = new TopologyStretcher(geometry, geometry2);
            if (this.maskEnv != null) {
                boolean bl = this.isViewPerformant = topologyStretcher.numVerticesInMask(this.maskEnv) < 500;
            }
            if (!this.isViewPerformant) {
                return;
            }
            this.stretchGeom = topologyStretcher.stretch(this.nearnessTol, this.stretchSize, this.maskEnv);
            this.stretchCoords = topologyStretcher.getModifiedCoordinates();
        }
    }

    private boolean isCacheValid() {
        if (this.stretchGeom == null) {
            this.stretchGeom = new Geometry[2];
            return false;
        }
        return true;
    }

    private class StretchedGeometryContainer
    implements GeometryContainer {
        private int index;

        public StretchedGeometryContainer(int n) {
            this.index = n;
        }

        public Geometry getGeometry() {
            return GeometryStretcherView.this.getStretchedGeometry(this.index);
        }
    }
}

