/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.io.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.EndianDataInputStream;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.MultiLineHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.MultiPointHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.PointHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.PolygonHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeHandler;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeTypeNotSupportedException;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapefileException;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapefileHeader;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class Shapefile {
    static final int SHAPEFILE_ID = 9994;
    static final int VERSION = 1000;
    public static final int NULL = 0;
    public static final int POINT = 1;
    public static final int POINTZ = 11;
    public static final int POINTM = 21;
    public static final int ARC = 3;
    public static final int ARCM = 23;
    public static final int ARCZ = 13;
    public static final int POLYGON = 5;
    public static final int POLYGONM = 25;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINT = 8;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPOINTZ = 18;
    public static final int UNDEFINED = -1;
    public static final int XY = 2;
    public static final int XYM = 3;
    public static final int XYZM = 4;
    private URL baseURL;
    private InputStream myInputStream;
    private GeometryFactory geomFactory;
    private EndianDataInputStream file;
    private ShapefileHeader mainHeader;
    private ShapeHandler handler;
    private int recordNumber;

    public Shapefile(URL uRL) {
        this.baseURL = uRL;
        this.myInputStream = null;
        try {
            URLConnection uRLConnection = this.baseURL.openConnection();
            this.myInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Shapefile(InputStream inputStream) {
        this.myInputStream = inputStream;
    }

    private EndianDataInputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Could not make a connection to the URL: " + this.baseURL);
        }
        EndianDataInputStream endianDataInputStream = new EndianDataInputStream(this.myInputStream);
        return endianDataInputStream;
    }

    public GeometryCollection read(GeometryFactory geometryFactory) throws IOException, ShapefileException, Exception {
        EndianDataInputStream endianDataInputStream = this.getInputStream();
        if (endianDataInputStream == null) {
            throw new IOException("Failed connection or no content for " + this.baseURL);
        }
        ShapefileHeader shapefileHeader = new ShapefileHeader(endianDataInputStream);
        if (shapefileHeader.getVersion() < 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + shapefileHeader.getVersion() + ") older that supported (" + 1000 + "), attempting to read anyway");
        }
        if (shapefileHeader.getVersion() > 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + shapefileHeader.getVersion() + ") newer that supported (" + 1000 + "), attempting to read anyway");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = shapefileHeader.getShapeType();
        ShapeHandler shapeHandler = Shapefile.getShapeHandler(n);
        if (shapeHandler == null) {
            throw new ShapeTypeNotSupportedException("Unsuported shape type:" + n);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            while (true) {
                n2 = endianDataInputStream.readIntBE();
                n3 = endianDataInputStream.readIntBE();
                try {
                    Geometry geometry = shapeHandler.read(endianDataInputStream, geometryFactory, n3);
                    arrayList.add(geometry);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(new GeometryCollection(null, null, -1));
                }
                catch (Exception exception) {
                    System.out.println("Error processing record (a):" + n2);
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    arrayList.add(new GeometryCollection(null, null, -1));
                }
            }
        }
        catch (EOFException eOFException) {
            return geometryFactory.createGeometryCollection(arrayList.toArray(new Geometry[0]));
        }
    }

    public void readStream(GeometryFactory geometryFactory) throws IOException, ShapefileException, Exception {
        this.geomFactory = geometryFactory;
        this.file = this.getInputStream();
        if (this.file == null) {
            throw new IOException("Failed connection or no content for " + this.baseURL);
        }
        this.mainHeader = new ShapefileHeader(this.file);
        if (this.mainHeader.getVersion() < 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + this.mainHeader.getVersion() + ") older that supported (" + 1000 + "), attempting to read anyway");
        }
        if (this.mainHeader.getVersion() > 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + this.mainHeader.getVersion() + ") newer that supported (" + 1000 + "), attempting to read anyway");
        }
        int n = this.mainHeader.getShapeType();
        this.handler = Shapefile.getShapeHandler(n);
        if (this.handler == null) {
            throw new ShapeTypeNotSupportedException("Unsuported shape type:" + n);
        }
        this.recordNumber = 0;
    }

    public Geometry next() throws IOException {
        Geometry geometry = null;
        try {
            this.recordNumber = this.file.readIntBE();
            int n = this.file.readIntBE();
            try {
                geometry = this.handler.read(this.file, this.geomFactory, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                geometry = new GeometryCollection(null, null, -1);
            }
            catch (Exception exception) {
                System.out.println("Error processing record (a):" + this.recordNumber);
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                geometry = new GeometryCollection(null, null, -1);
            }
        }
        catch (EOFException eOFException) {
            this.close();
        }
        return geometry;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public static String getShapeTypeDescription(int n) {
        switch (n) {
            case 0: {
                return "Null";
            }
            case 1: {
                return "Points";
            }
            case 11: {
                return "Points Z";
            }
            case 21: {
                return "Points M";
            }
            case 3: {
                return "Arcs";
            }
            case 23: {
                return "ArcsM";
            }
            case 13: {
                return "ArcsM";
            }
            case 5: {
                return "Polygon";
            }
            case 25: {
                return "PolygonM";
            }
            case 15: {
                return "PolygonZ";
            }
            case 8: {
                return "Multipoint";
            }
            case 28: {
                return "MultipointM";
            }
            case 18: {
                return "MultipointZ";
            }
        }
        return "Undefined";
    }

    public static ShapeHandler getShapeHandler(Geometry geometry, int n) throws Exception {
        return Shapefile.getShapeHandler(Shapefile.getShapeType(geometry, n));
    }

    public static ShapeHandler getShapeHandler(int n) throws Exception {
        switch (n) {
            case 1: {
                return new PointHandler();
            }
            case 11: {
                return new PointHandler(11);
            }
            case 21: {
                return new PointHandler(21);
            }
            case 5: {
                return new PolygonHandler();
            }
            case 25: {
                return new PolygonHandler(25);
            }
            case 15: {
                return new PolygonHandler(15);
            }
            case 3: {
                return new MultiLineHandler();
            }
            case 23: {
                return new MultiLineHandler(23);
            }
            case 13: {
                return new MultiLineHandler(13);
            }
            case 8: {
                return new MultiPointHandler();
            }
            case 28: {
                return new MultiPointHandler(28);
            }
            case 18: {
                return new MultiPointHandler(18);
            }
        }
        return null;
    }

    public static int getShapeType(Geometry geometry, int n) throws ShapefileException {
        if (n != 2 && n != 3 && n != 4) {
            throw new ShapefileException("invalid ShapeFileDimentions for getShapeType - expected 2,3,or 4 but got " + n + "  (2=x,y ; 3=x,y,m ; 4=x,y,z,m)");
        }
        if (geometry instanceof Point) {
            switch (n) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 21;
                }
                case 4: {
                    return 11;
                }
            }
        }
        if (geometry instanceof MultiPoint) {
            switch (n) {
                case 2: {
                    return 8;
                }
                case 3: {
                    return 28;
                }
                case 4: {
                    return 18;
                }
            }
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            switch (n) {
                case 2: {
                    return 5;
                }
                case 3: {
                    return 25;
                }
                case 4: {
                    return 15;
                }
            }
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            switch (n) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 23;
                }
                case 4: {
                    return 13;
                }
            }
        }
        return -1;
    }

    public synchronized void readIndex(InputStream inputStream) throws IOException {
        Object object;
        EndianDataInputStream endianDataInputStream = null;
        try {
            object = new BufferedInputStream(inputStream);
            endianDataInputStream = new EndianDataInputStream((InputStream)object);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        object = new ShapefileHeader(endianDataInputStream);
        boolean bl = false;
        boolean bl2 = false;
        endianDataInputStream.close();
    }
}

