/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jtstest.testbuilder.ValidPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ValidPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ValidPanel
extends JPanel {
    TestCaseEdit testCase;
    private Coordinate markPoint = null;
    JButton btnValidate = new JButton();
    JButton btnSimple = new JButton();
    JTextField txtIsValid = new JTextField();
    JTextArea taInvalidMsg = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private transient Vector validPanelListeners;
    GridLayout gridLayout1 = new GridLayout();
    JPanel markPanel = new JPanel();
    JPanel markSquishPanel = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel markBtnPanel = new JPanel();
    JTextField txtMark = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel markLabel = new JLabel();
    JButton btnClearMark = new JButton();
    JButton btnSetMark = new JButton();

    public ValidPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.btnValidate.setText("Valid?");
        this.btnValidate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnValidate_actionPerformed(actionEvent);
            }
        });
        this.btnSimple.setText("Simple?");
        this.btnSimple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnSimple_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.gridLayout1);
        this.txtIsValid.setBackground(SystemColor.control);
        this.txtIsValid.setEditable(false);
        this.txtIsValid.setText("Y");
        this.txtIsValid.setHorizontalAlignment(0);
        this.taInvalidMsg.setPreferredSize(new Dimension(70, 80));
        this.taInvalidMsg.setLineWrap(true);
        this.taInvalidMsg.setBorder(BorderFactory.createLoweredBevelBorder());
        this.taInvalidMsg.setMinimumSize(new Dimension(70, 70));
        this.taInvalidMsg.setToolTipText("");
        this.taInvalidMsg.setBackground(SystemColor.inactiveCaptionText);
        this.taInvalidMsg.setEditable(false);
        this.taInvalidMsg.setFont(new Font("SansSerif", 0, 12));
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Valid / Simple ");
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.gridLayout1.setRows(2);
        this.markLabel.setToolTipText("");
        this.markLabel.setText("Mark Point ( X Y ) ");
        this.btnClearMark.setToolTipText("");
        this.btnClearMark.setText("Clear Mark");
        this.btnClearMark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnClearMark_actionPerformed(actionEvent);
            }
        });
        this.btnSetMark.setToolTipText("");
        this.btnSetMark.setText("Set Mark");
        this.btnSetMark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnSetMark_actionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.btnValidate);
        this.jPanel3.add(this.btnSimple);
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.jPanel1.add((Component)this.txtIsValid, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 0, 4, 0), 10, 0));
        this.jPanel1.add((Component)this.taInvalidMsg, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.add((Component)this.jPanel1, null);
        this.markPanel.setLayout(new BorderLayout());
        this.markBtnPanel.add(this.btnSetMark);
        this.markBtnPanel.add(this.btnClearMark);
        this.markPanel.add((Component)this.markLabel, "North");
        this.markPanel.add((Component)this.txtMark, "Center");
        this.markPanel.add((Component)this.markBtnPanel, "South");
        this.markSquishPanel.setLayout(new BorderLayout());
        this.markSquishPanel.add((Component)this.markPanel, "North");
        this.add((Component)this.markSquishPanel, null);
    }

    public void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
    }

    public Coordinate getMarkPoint() {
        return this.markPoint;
    }

    void btnValidate_actionPerformed(ActionEvent actionEvent) {
        String string;
        TopologyValidationError topologyValidationError = null;
        if (this.testCase.getGeometry(0) != null) {
            string = new IsValidOp(this.testCase.getGeometry(0));
            topologyValidationError = string.getValidationError();
        }
        string = "";
        boolean bl = true;
        Coordinate coordinate = null;
        if (topologyValidationError != null) {
            bl = false;
            string = topologyValidationError.toString();
            coordinate = topologyValidationError.getCoordinate();
        }
        this.taInvalidMsg.setText(string);
        this.txtIsValid.setText(bl ? "Y" : "N");
        this.setMarkPoint(coordinate);
    }

    void btnSimple_actionPerformed(ActionEvent actionEvent) {
        String string;
        boolean bl = true;
        Coordinate coordinate = null;
        if (this.testCase.getGeometry(0) != null) {
            string = new IsSimpleOp(this.testCase.getGeometry(0));
            bl = string.isSimple();
            coordinate = string.getNonSimpleLocation();
        }
        string = bl ? "" : "Self-intersection at " + WKTWriter.toPoint(coordinate);
        this.taInvalidMsg.setText(string);
        this.txtIsValid.setText(bl ? "Y" : "N");
        this.setMarkPoint(coordinate);
    }

    private void setMarkPoint(Coordinate coordinate) {
        this.markPoint = coordinate;
        String string = "";
        if (this.markPoint != null) {
            string = " " + coordinate.x + "  " + coordinate.y + " ";
        }
        this.txtMark.setText(string);
        this.fireSetHighlightPerformed(new ValidPanelEvent(this));
    }

    public synchronized void removeValidPanelListener(ValidPanelListener validPanelListener) {
        if (this.validPanelListeners != null && this.validPanelListeners.contains(validPanelListener)) {
            Vector vector = (Vector)this.validPanelListeners.clone();
            vector.removeElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    public synchronized void addValidPanelListener(ValidPanelListener validPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.validPanelListeners == null ? new Vector(2) : (Vector)this.validPanelListeners.clone();
        if (!vector.contains(validPanelListener)) {
            vector.addElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    protected void fireSetHighlightPerformed(ValidPanelEvent validPanelEvent) {
        if (this.validPanelListeners != null) {
            Vector vector = this.validPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ValidPanelListener)vector.elementAt(i)).setHighlightPerformed(validPanelEvent);
            }
        }
    }

    void btnSetMark_actionPerformed(ActionEvent actionEvent) {
        String string = this.txtMark.getText();
        this.setMarkPoint(this.parseXY(string));
    }

    void btnClearMark_actionPerformed(ActionEvent actionEvent) {
        this.setMarkPoint(null);
    }

    Coordinate parseXY(String string) {
        String[] stringArray = string.trim().split("\\s+");
        double d = this.parseNumber(stringArray, 0);
        double d2 = this.parseNumber(stringArray, 1);
        return new Coordinate(d, d2);
    }

    double parseNumber(String[] stringArray, int n) {
        if (stringArray.length <= n) {
            return 0.0;
        }
        String string = stringArray[n];
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

