/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testbuilder.GeometryEditControlPanel;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.RelatePanel;
import com.vividsolutions.jtstest.testbuilder.ScalarFunctionPanel;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanel;
import com.vividsolutions.jtstest.testbuilder.ValidPanel;
import com.vividsolutions.jtstest.testbuilder.ValidPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ValidPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestCasePanel
extends JPanel {
    TestCaseEdit testCase;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout editFrameLayout = new BorderLayout();
    JPanel editFramePanel = new JPanel();
    GeometryEditPanel editPanel = new GeometryEditPanel();
    ButtonGroup geometryType = new ButtonGroup();
    ButtonGroup editMode = new ButtonGroup();
    ButtonGroup partType = new ButtonGroup();
    Border border4;
    JPanel editGroupPanel = new JPanel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel btnPanel = new JPanel();
    JPanel relateTabPanel = new JPanel();
    JButton btnRunTests = new JButton();
    RelatePanel relatePanel = new RelatePanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GeometryEditControlPanel editCtlPanel = new GeometryEditControlPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JTextField txtDesc = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    SpatialFunctionPanel spatialFunctionPanel = new SpatialFunctionPanel();
    private int currentTestCaseIndex = 0;
    private int maxTestCaseIndex = 0;
    private boolean initialized = false;
    JPanel casePrecisionModelPanel = new JPanel();
    JPanel namePanel = new JPanel();
    JLabel testCaseIndexLabel = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel precisionModelLabel = new JLabel();
    ValidPanel validPanel = new ValidPanel();
    JPanel statusBarPanel = new JPanel();
    JLabel lblMousePos = new JLabel();
    JLabel lblPrecisionModel = new JLabel();
    ScalarFunctionPanel scalarFunctionPanel = new ScalarFunctionPanel();
    private TestBuilderModel tbModel;
    private static double LOG_10 = Math.log(10.0);

    public TestCasePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialized = true;
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
        this.editPanel.setModel(testBuilderModel);
        this.editCtlPanel.setModel(testBuilderModel);
    }

    public void setCurrentTestCaseIndex(int n) {
        this.currentTestCaseIndex = n;
        this.updateTestCaseIndexLabel();
    }

    public void setMaxTestCaseIndex(int n) {
        this.maxTestCaseIndex = n;
        this.updateTestCaseIndexLabel();
    }

    public GeometryEditControlPanel getGeometryEditControlPanel() {
        return this.editCtlPanel;
    }

    public GeometryEditPanel getGeometryEditPanel() {
        return this.editPanel;
    }

    public SpatialFunctionPanel getSpatialFunctionPanel() {
        return this.spatialFunctionPanel;
    }

    public ScalarFunctionPanel getScalarFunctionPanel() {
        return this.scalarFunctionPanel;
    }

    void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
        this.tbModel.getGeometryEditModel().setTestCase(testCaseEdit);
        this.relatePanel.setTestCase(testCaseEdit);
        this.validPanel.setTestCase(testCaseEdit);
        this.txtDesc.setText(testCaseEdit.getName());
    }

    void editPanel_mouseMoved(MouseEvent mouseEvent) {
        String string = this.cursorLocation(mouseEvent.getPoint());
        this.lblMousePos.setText(string);
    }

    private String cursorLocation(Point2D point2D) {
        Point2D point2D2 = this.editPanel.getViewport().toModel(point2D);
        double d = this.editPanel.getViewport().getWidthInModel();
        double d2 = this.editPanel.getViewport().getHeightInModel();
        double d3 = Math.min(d, d2);
        double d4 = -Math.floor(Math.log(d3) / Math.log(10.0)) + 3.0;
        double d5 = Math.pow(10.0, d4);
        double d6 = (double)Math.round(point2D2.getX() * d5) / d5;
        double d7 = (double)Math.round(point2D2.getY() * d5) / d5;
        NumberFormat numberFormat = this.editPanel.getViewport().getScaleFormat();
        return numberFormat.format(point2D2.getX()) + ", " + numberFormat.format(point2D2.getY());
    }

    void btnRunTests_actionPerformed(ActionEvent actionEvent) {
        this.relatePanel.runTests();
    }

    void editPanel_geometryChanged(GeometryEvent geometryEvent) {
        this.relatePanel.clearResults();
    }

    void validPanel_setHighlightPerformed(ValidPanelEvent validPanelEvent) {
        this.editPanel.setHighlightPoint(this.validPanel.getMarkPoint());
        this.editPanel.forceRepaint();
    }

    void txtDesc_focusLost(FocusEvent focusEvent) {
        this.testCase.setName(this.txtDesc.getText());
    }

    void jTabbedPane1_stateChanged(ChangeEvent changeEvent) {
        boolean bl = this.jTabbedPane1.getSelectedComponent() == this.spatialFunctionPanel;
        boolean bl2 = this.jTabbedPane1.getSelectedComponent() == this.editCtlPanel;
        this.editPanel.setShowingResult(bl);
        this.editPanel.setShowingGeometryA(!bl || this.spatialFunctionPanel.shouldShowGeometryA());
        this.editPanel.setShowingGeometryB(!bl || this.spatialFunctionPanel.shouldShowGeometryB());
        this.editPanel.setHighlightPoint(null);
        if (this.jTabbedPane1.getSelectedComponent() == this.validPanel || this.jTabbedPane1.getSelectedComponent() == this.editCtlPanel) {
            this.editPanel.setHighlightPoint(this.validPanel.getMarkPoint());
        }
        if (this.initialized) {
            if (bl2) {
                JTSTestBuilderFrame.instance().showGeomsTab();
            }
            if (bl) {
                JTSTestBuilderFrame.instance().showResultWKTTab();
            }
        }
    }

    public void setPrecisionModelDescription(String string) {
        this.precisionModelLabel.setText(string);
        this.lblPrecisionModel.setText(" PM: " + string);
    }

    private void jbInit() throws Exception {
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134));
        this.setLayout(this.borderLayout1);
        this.editGroupPanel.setLayout(this.borderLayout3);
        this.editPanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                TestCasePanel.this.editPanel_mouseMoved(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                TestCasePanel.this.editPanel_mouseMoved(mouseEvent);
            }
        });
        this.relateTabPanel.setLayout(this.borderLayout2);
        this.btnRunTests.setToolTipText("");
        this.btnRunTests.setText("Run");
        this.btnRunTests.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCasePanel.this.btnRunTests_actionPerformed(actionEvent);
            }
        });
        this.validPanel.addValidPanelListener(new ValidPanelListener(){

            public void setHighlightPerformed(ValidPanelEvent validPanelEvent) {
                TestCasePanel.this.validPanel_setHighlightPerformed(validPanelEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.txtDesc.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TestCasePanel.this.txtDesc_focusLost(focusEvent);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestCasePanel.this.jTabbedPane1_stateChanged(changeEvent);
            }
        });
        this.testCaseIndexLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.testCaseIndexLabel.setToolTipText("");
        this.testCaseIndexLabel.setText("0 of 0");
        this.casePrecisionModelPanel.setLayout(this.gridBagLayout2);
        this.namePanel.setLayout(this.gridBagLayout3);
        this.precisionModelLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.precisionModelLabel.setToolTipText("Precision Model");
        this.precisionModelLabel.setText("");
        this.txtDesc.setBackground(Color.white);
        this.lblMousePos.setBackground(SystemColor.text);
        this.lblMousePos.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lblMousePos.setPreferredSize(new Dimension(21, 21));
        this.lblMousePos.setHorizontalAlignment(4);
        this.lblPrecisionModel.setBackground(SystemColor.text);
        this.lblPrecisionModel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lblPrecisionModel.setText("Sel Pt:");
        this.editFramePanel.setLayout(this.editFrameLayout);
        this.editFramePanel.add((Component)this.editPanel, "Center");
        this.editFramePanel.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)this.editGroupPanel, "Center");
        this.editGroupPanel.add((Component)this.editFramePanel, "Center");
        this.editGroupPanel.add((Component)this.statusBarPanel, "South");
        this.statusBarPanel.setLayout(new GridLayout(1, 2));
        this.statusBarPanel.add(this.testCaseIndexLabel);
        this.statusBarPanel.add(this.lblPrecisionModel);
        this.statusBarPanel.add(this.lblMousePos);
        this.add((Component)this.jTabbedPane1, "West");
        this.jTabbedPane1.add((Component)this.editCtlPanel, "Edit");
        this.jTabbedPane1.add((Component)this.validPanel, "Valid/Mask");
        this.jTabbedPane1.add((Component)this.relateTabPanel, "Predicates");
        this.jTabbedPane1.add((Component)this.spatialFunctionPanel, "Geometry Functions");
        this.jTabbedPane1.add((Component)this.scalarFunctionPanel, "Scalar Functions");
        this.relateTabPanel.add((Component)this.relatePanel, "Center");
        this.relateTabPanel.add((Component)this.btnPanel, "North");
        this.btnPanel.add((Component)this.btnRunTests, null);
    }

    private void updateTestCaseIndexLabel() {
        this.testCaseIndexLabel.setText("Case " + this.currentTestCaseIndex + " of " + this.maxTestCaseIndex);
    }
}

