/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.command.CommandLine;
import com.vividsolutions.jtstest.command.Option;
import com.vividsolutions.jtstest.command.OptionSpec;
import com.vividsolutions.jtstest.command.ParseException;
import com.vividsolutions.jtstest.function.GeometryFunctionRegistry;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;

public class JTSTestBuilder {
    private static final String OPT_GEOMFUNC = "geomfunc";
    private static GeometryFunctionRegistry funcRegistry = GeometryFunctionRegistry.createTestBuilderRegistry();
    private static CommandLine commandLine = JTSTestBuilder.createCmdLine();
    public static JTSTestBuilder app;
    private TestBuilderModel tbModel = new TestBuilderModel();
    boolean packFrame = false;

    public static JTSTestBuilder instance() {
        return app;
    }

    public static TestBuilderModel model() {
        return JTSTestBuilder.instance().tbModel;
    }

    public static Geometry getGeometryA() {
        return JTSTestBuilder.model().getGeometryEditModel().getGeometry(0);
    }

    public static Geometry getGeometryB() {
        return JTSTestBuilder.model().getGeometryEditModel().getGeometry(1);
    }

    private static CommandLine createCmdLine() {
        commandLine = new CommandLine('-');
        commandLine.addOptionSpec(new OptionSpec(OPT_GEOMFUNC, -2));
        return commandLine;
    }

    public static GeometryFunctionRegistry getFunctionRegistry() {
        return funcRegistry;
    }

    public static PrecisionModel getPrecisionModel() {
        return JTSTestBuilder.model().getPrecisionModel();
    }

    public static GeometryFactory getGeometryFactory() {
        return JTSTestBuilder.model().getGeometryFactory();
    }

    private void initFrame() {
        JTSTestBuilderFrame jTSTestBuilderFrame = new JTSTestBuilderFrame();
        jTSTestBuilderFrame.setModel(JTSTestBuilder.model());
        if (this.packFrame) {
            jTSTestBuilderFrame.pack();
        } else {
            jTSTestBuilderFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jTSTestBuilderFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jTSTestBuilderFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jTSTestBuilderFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            JTSTestBuilder.readArgs(stringArray);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            app = new JTSTestBuilder();
            app.initFrame();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void readArgs(String[] stringArray) throws ParseException, ClassNotFoundException {
        commandLine.parse(stringArray);
        if (commandLine.hasOption(OPT_GEOMFUNC)) {
            Option option = commandLine.getOption(OPT_GEOMFUNC);
            for (int i = 0; i < option.getNumArgs(); ++i) {
                String string = option.getArg(i);
                try {
                    funcRegistry.add(string);
                    System.out.println("Added Geometry Functions from: " + string);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Unable to load function class: " + string);
                }
            }
        }
    }
}

