/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.function.BaseGeometryFunction;
import com.vividsolutions.jtstest.function.DoubleKeyMap;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionEvent;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionListener;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class GeometryFunctionTreePanel
extends JPanel {
    JScrollPane jScrollPane = new JScrollPane();
    JTree tree = new JTree();
    BorderLayout borderLayout = new BorderLayout();
    Border border1;
    private transient Vector eventListeners;

    private static GeometryFunction getFunctionFromNode(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof GeometryFunction) {
            return (GeometryFunction)object2;
        }
        return null;
    }

    public GeometryFunctionTreePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(200, 250);
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.setLayout(this.borderLayout);
        this.setBorder(this.border1);
        this.add((Component)this.jScrollPane, "Center");
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new GeometryFunctionRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GeometryFunction geometryFunction;
                if (mouseEvent.getClickCount() == 2 && (geometryFunction = GeometryFunctionTreePanel.this.getFunction()) != null) {
                    GeometryFunctionTreePanel.this.fireFunctionInvoked(new GeometryFunctionEvent(geometryFunction));
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                GeometryFunction geometryFunction = GeometryFunctionTreePanel.this.getFunction();
                if (geometryFunction != null) {
                    GeometryFunctionTreePanel.this.fireFunctionSelected(new GeometryFunctionEvent(geometryFunction));
                }
            }
        });
    }

    public GeometryFunction getFunction() {
        return GeometryFunctionTreePanel.getFunctionFromNode(this.tree.getLastSelectedPathComponent());
    }

    public void populate(DoubleKeyMap doubleKeyMap) {
        this.tree.setModel(this.createModel(doubleKeyMap));
    }

    private TreeModel createModel(DoubleKeyMap doubleKeyMap) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        Set set = doubleKeyMap.keySet();
        for (String string : set) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            Collection collection = doubleKeyMap.values(string);
            for (Object e : collection) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(e));
            }
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public synchronized void removeGeometryFunctionListener(GeometryFunctionListener geometryFunctionListener) {
        if (this.eventListeners != null && this.eventListeners.contains(geometryFunctionListener)) {
            Vector vector = (Vector)this.eventListeners.clone();
            vector.removeElement(geometryFunctionListener);
            this.eventListeners = vector;
        }
    }

    public synchronized void addGeometryFunctionListener(GeometryFunctionListener geometryFunctionListener) {
        Vector vector;
        Vector vector2 = vector = this.eventListeners == null ? new Vector(2) : (Vector)this.eventListeners.clone();
        if (!vector.contains(geometryFunctionListener)) {
            vector.addElement(geometryFunctionListener);
            this.eventListeners = vector;
        }
    }

    protected void fireFunctionSelected(GeometryFunctionEvent geometryFunctionEvent) {
        if (this.eventListeners != null) {
            Vector vector = this.eventListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryFunctionListener)vector.elementAt(i)).functionSelected(geometryFunctionEvent);
            }
        }
    }

    protected void fireFunctionInvoked(GeometryFunctionEvent geometryFunctionEvent) {
        if (this.eventListeners != null) {
            Vector vector = this.eventListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GeometryFunctionListener)vector.elementAt(i)).functionInvoked(geometryFunctionEvent);
            }
        }
    }

    private class GeometryFunctionRenderer
    extends DefaultTreeCellRenderer {
        private final ImageIcon binaryIcon = new ImageIcon(this.getClass().getResource("BinaryGeomFunction.png"));
        private final ImageIcon unaryIcon = new ImageIcon(this.getClass().getResource("UnaryGeomFunction.png"));

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3) {
                GeometryFunction geometryFunction = GeometryFunctionTreePanel.getFunctionFromNode(object);
                boolean bl5 = BaseGeometryFunction.isBinaryGeomFunction(geometryFunction);
                this.setIcon(bl5 ? this.binaryIcon : this.unaryIcon);
                String string = StringUtil.capitalize(geometryFunction.getName());
                this.setText(string);
                this.setToolTipText(geometryFunction.getSignature() + geometryFunction.getDescription());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

