/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtsexample.geom.ExtendedCoordinate;

public class ExtendedCoordinateSequence
implements CoordinateSequence {
    private ExtendedCoordinate[] coordinates;

    public static ExtendedCoordinate[] copy(Coordinate[] coordinateArray) {
        ExtendedCoordinate[] extendedCoordinateArray = new ExtendedCoordinate[coordinateArray.length];
        for (int i = 0; i < coordinateArray.length; ++i) {
            extendedCoordinateArray[i] = new ExtendedCoordinate(coordinateArray[i]);
        }
        return extendedCoordinateArray;
    }

    public static ExtendedCoordinate[] copy(CoordinateSequence coordinateSequence) {
        ExtendedCoordinate[] extendedCoordinateArray = new ExtendedCoordinate[coordinateSequence.size()];
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            extendedCoordinateArray[i] = new ExtendedCoordinate(coordinateSequence.getCoordinate(i));
        }
        return extendedCoordinateArray;
    }

    public ExtendedCoordinateSequence(ExtendedCoordinate[] extendedCoordinateArray) {
        this.coordinates = extendedCoordinateArray;
    }

    public ExtendedCoordinateSequence(Coordinate[] coordinateArray) {
        this.coordinates = ExtendedCoordinateSequence.copy(coordinateArray);
    }

    public ExtendedCoordinateSequence(CoordinateSequence coordinateSequence) {
        this.coordinates = ExtendedCoordinateSequence.copy(coordinateSequence);
    }

    public ExtendedCoordinateSequence(int n) {
        this.coordinates = new ExtendedCoordinate[n];
        for (int i = 0; i < n; ++i) {
            this.coordinates[i] = new ExtendedCoordinate();
        }
    }

    public int getDimension() {
        return 4;
    }

    public Coordinate getCoordinate(int n) {
        return this.coordinates[n];
    }

    public Coordinate getCoordinateCopy(int n) {
        return new Coordinate((Coordinate)this.coordinates[n]);
    }

    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.coordinates[n].x;
        coordinate.y = this.coordinates[n].y;
    }

    public double getX(int n) {
        return this.coordinates[n].x;
    }

    public double getY(int n) {
        return this.coordinates[n].y;
    }

    public double getOrdinate(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.coordinates[n].x;
            }
            case 1: {
                return this.coordinates[n].y;
            }
            case 2: {
                return this.coordinates[n].z;
            }
            case 3: {
                return this.coordinates[n].getM();
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int n, int n2, double d) {
        switch (n2) {
            case 0: {
                this.coordinates[n].x = d;
                break;
            }
            case 1: {
                this.coordinates[n].y = d;
                break;
            }
            case 2: {
                this.coordinates[n].z = d;
                break;
            }
            case 3: {
                this.coordinates[n].setM(d);
            }
        }
    }

    public Object clone() {
        ExtendedCoordinate[] extendedCoordinateArray = new ExtendedCoordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            extendedCoordinateArray[i] = (ExtendedCoordinate)((Object)this.coordinates[i].clone());
        }
        return new ExtendedCoordinateSequence(extendedCoordinateArray);
    }

    public int size() {
        return this.coordinates.length;
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope envelope) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            envelope.expandToInclude((Coordinate)this.coordinates[i]);
        }
        return envelope;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ExtendedCoordinateSequence [");
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((Object)this.coordinates[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

