/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class GeometryRenderer {
    public static void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D, Color color, Color color2) {
        ShapeWriter shapeWriter = new ShapeWriter((PointTransformation)viewport);
        GeometryRenderer.paint(geometry, viewport, shapeWriter, graphics2D, color, color2);
    }

    public static void paint(Geometry geometry, Viewport viewport, ShapeWriter shapeWriter, Graphics2D graphics2D, Color color, Color color2) {
        if (geometry == null) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryRenderer.paintGeometryCollection((GeometryCollection)geometry, viewport, shapeWriter, graphics2D, color, color2);
            return;
        }
        Shape shape = shapeWriter.toShape(geometry);
        if (!(shape instanceof GeneralPath) && color2 != null) {
            graphics2D.setPaint(color2);
            graphics2D.fill(shape);
        }
        if (color != null) {
            graphics2D.setColor(color);
            try {
                graphics2D.draw(shape);
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
        }
    }

    private static void paintGeometryCollection(GeometryCollection geometryCollection, Viewport viewport, ShapeWriter shapeWriter, Graphics2D graphics2D, Color color, Color color2) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            GeometryRenderer.paint(geometryCollection.getGeometryN(i), viewport, shapeWriter, graphics2D, color, color2);
        }
    }
}

