/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.render.Style;
import java.awt.Graphics2D;

public class GeometryPainter {
    public static void paint(Graphics2D graphics2D, Viewport viewport, Geometry geometry, Style style) throws Exception {
        if (geometry == null) {
            return;
        }
        if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryPainter.paintGeometryCollection(graphics2D, viewport, (GeometryCollection)geometry, style);
            return;
        }
        style.paint(geometry, viewport, graphics2D);
    }

    private static void paintGeometryCollection(Graphics2D graphics2D, Viewport viewport, GeometryCollection geometryCollection, Style style) throws Exception {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            GeometryPainter.paint(graphics2D, viewport, geometryCollection.getGeometryN(i), style);
        }
    }
}

