/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jtstest.testbuilder.ValidPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ValidPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ValidPanel
extends JPanel {
    TestCaseEdit testCase;
    Coordinate highlightPoint = null;
    JButton btnValidate = new JButton();
    JButton btnSimple = new JButton();
    JTextField txtIsValid = new JTextField();
    JTextArea taInvalidMsg = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private transient Vector validPanelListeners;
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JTextField txtX = new JTextField();
    JTextField txtY = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JButton btnClearMark = new JButton();
    JButton btnSetMark = new JButton();

    public ValidPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.btnValidate.setText("Valid?");
        this.btnValidate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnValidate_actionPerformed(actionEvent);
            }
        });
        this.btnSimple.setText("Simple?");
        this.btnSimple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnSimple_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.gridLayout1);
        this.txtIsValid.setBackground(SystemColor.control);
        this.txtIsValid.setEditable(false);
        this.txtIsValid.setText("Y");
        this.txtIsValid.setHorizontalAlignment(0);
        this.taInvalidMsg.setPreferredSize(new Dimension(70, 80));
        this.taInvalidMsg.setLineWrap(true);
        this.taInvalidMsg.setBorder(BorderFactory.createLoweredBevelBorder());
        this.taInvalidMsg.setMinimumSize(new Dimension(70, 70));
        this.taInvalidMsg.setToolTipText("");
        this.taInvalidMsg.setBackground(SystemColor.inactiveCaptionText);
        this.taInvalidMsg.setEditable(false);
        this.taInvalidMsg.setFont(new Font("SansSerif", 0, 12));
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Valid / Simple ");
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.gridLayout1.setRows(2);
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jLabel2.setToolTipText("");
        this.jLabel2.setText("X ");
        this.jLabel3.setToolTipText("");
        this.jLabel3.setText("Y ");
        this.btnClearMark.setToolTipText("");
        this.btnClearMark.setText("Clear Mark");
        this.btnClearMark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnClearMark_actionPerformed(actionEvent);
            }
        });
        this.btnSetMark.setToolTipText("");
        this.btnSetMark.setText("Set Mark");
        this.btnSetMark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidPanel.this.btnSetMark_actionPerformed(actionEvent);
            }
        });
        this.txtX.setToolTipText("");
        this.jPanel3.add(this.btnValidate);
        this.jPanel3.add(this.btnSimple);
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.jPanel1.add((Component)this.txtIsValid, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 0, 4, 0), 10, 0));
        this.jPanel1.add((Component)this.taInvalidMsg, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.add((Component)this.jPanel1, null);
        this.jPanel2.add((Component)this.txtY, new GridBagConstraints(1, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 20), 0, 0));
        this.jPanel2.add((Component)this.txtX, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 20), 0, 0));
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.btnSetMark, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 4, 10), 0, 0));
        this.jPanel2.add((Component)this.btnClearMark, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 4, 10), 0, 0));
        this.add((Component)this.jPanel2, null);
    }

    public void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
    }

    public Coordinate getHighlightPoint() {
        return this.highlightPoint;
    }

    void btnValidate_actionPerformed(ActionEvent actionEvent) {
        String string;
        TopologyValidationError topologyValidationError = null;
        if (this.testCase.getGeometry(0) != null) {
            string = new IsValidOp(this.testCase.getGeometry(0));
            topologyValidationError = string.getValidationError();
        }
        string = "";
        boolean bl = true;
        Coordinate coordinate = null;
        if (topologyValidationError != null) {
            bl = false;
            string = topologyValidationError.toString();
            coordinate = topologyValidationError.getCoordinate();
        }
        this.taInvalidMsg.setText(string);
        this.txtIsValid.setText(bl ? "Y" : "N");
        this.setHighlightPoint(coordinate);
    }

    void btnSimple_actionPerformed(ActionEvent actionEvent) {
        String string;
        boolean bl = true;
        Coordinate coordinate = null;
        if (this.testCase.getGeometry(0) != null) {
            string = new IsSimpleOp(this.testCase.getGeometry(0));
            bl = string.isSimple();
            coordinate = string.getNonSimpleLocation();
        }
        string = bl ? "" : "Self-intersection at " + WKTWriter.toPoint(coordinate);
        this.taInvalidMsg.setText(string);
        this.txtIsValid.setText(bl ? "Y" : "N");
        this.setHighlightPoint(coordinate);
    }

    private void setHighlightPoint(Coordinate coordinate) {
        this.highlightPoint = coordinate;
        if (this.highlightPoint != null) {
            this.txtX.setText(Double.toString(coordinate.x));
            this.txtY.setText(Double.toString(coordinate.y));
        } else {
            this.txtX.setText("");
            this.txtY.setText("");
        }
        this.fireSetHighlightPerformed(new ValidPanelEvent(this));
    }

    public synchronized void removeValidPanelListener(ValidPanelListener validPanelListener) {
        if (this.validPanelListeners != null && this.validPanelListeners.contains(validPanelListener)) {
            Vector vector = (Vector)this.validPanelListeners.clone();
            vector.removeElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    public synchronized void addValidPanelListener(ValidPanelListener validPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.validPanelListeners == null ? new Vector(2) : (Vector)this.validPanelListeners.clone();
        if (!vector.contains(validPanelListener)) {
            vector.addElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    protected void fireSetHighlightPerformed(ValidPanelEvent validPanelEvent) {
        if (this.validPanelListeners != null) {
            Vector vector = this.validPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ValidPanelListener)vector.elementAt(i)).setHighlightPerformed(validPanelEvent);
            }
        }
    }

    void btnSetMark_actionPerformed(ActionEvent actionEvent) {
        double d = Double.parseDouble(this.txtX.getText());
        double d2 = Double.parseDouble(this.txtY.getText());
        this.setHighlightPoint(new Coordinate(d, d2));
    }

    void btnClearMark_actionPerformed(ActionEvent actionEvent) {
        this.setHighlightPoint(null);
    }
}

