/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Memory;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import com.vividsolutions.jtstest.util.ExceptionFormatter;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ResultWKTPanel
extends JPanel {
    TestBuilderModel tbModel = null;
    Object currResult = null;
    String opName = "";
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea txtResult = new JTextArea();
    JPanel labelPanel = new JPanel();
    JLabel functionLabel = new JLabel();
    JLabel timeLabel = new JLabel();
    JLabel memoryLabel = new JLabel();
    GridLayout labelPanelLayout = new GridLayout(1, 3);
    JPanel rPanel = new JPanel();
    JButton copyButton = new JButton();
    JButton copyToTestButton = new JButton();
    JPanel rButtonPanel = new JPanel();
    GridLayout rButtonPanelLayout = new GridLayout();
    BorderLayout rPanelLayout = new BorderLayout();
    BorderLayout tabPanelLayout = new BorderLayout();
    private final ImageIcon copyIcon = new ImageIcon(this.getClass().getResource("Copy.gif"));
    private final ImageIcon copyToTestIcon = new ImageIcon(this.getClass().getResource("CopyToTest.png"));

    public ResultWKTPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.tabPanelLayout);
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.copyButton.setToolTipText("Copy Result (Ctl-click for formatted)");
        this.copyButton.setIcon(this.copyIcon);
        this.copyButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyToTestButton.setToolTipText("Copy Result to new Test");
        this.copyToTestButton.setIcon(this.copyToTestIcon);
        this.copyToTestButton.setMargin(new Insets(0, 0, 0, 0));
        this.rButtonPanelLayout = new GridLayout(2, 1);
        this.rButtonPanelLayout.setVgap(1);
        this.rButtonPanelLayout.setHgap(1);
        this.rButtonPanel.setLayout(this.rButtonPanelLayout);
        this.rButtonPanel.add(this.copyButton);
        this.rButtonPanel.add(this.copyToTestButton);
        this.rPanel.setLayout(this.rPanelLayout);
        this.rPanel.add((Component)this.rButtonPanel, "North");
        this.txtResult.setWrapStyleWord(true);
        this.txtResult.setLineWrap(true);
        this.txtResult.setBackground(SystemColor.control);
        this.labelPanel.setLayout(this.labelPanelLayout);
        this.labelPanel.add(this.functionLabel);
        this.labelPanel.add(this.timeLabel);
        this.labelPanel.add(this.memoryLabel);
        this.functionLabel.setText(" ");
        this.functionLabel.setHorizontalAlignment(0);
        this.functionLabel.setToolTipText("Result Info");
        this.timeLabel.setText(" ");
        this.timeLabel.setHorizontalAlignment(4);
        this.timeLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.timeLabel.setToolTipText("Execution Time");
        this.memoryLabel.setText(" ");
        this.memoryLabel.setHorizontalAlignment(4);
        this.memoryLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.memoryLabel.setToolTipText("JVM Memory Usage");
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.labelPanel, "North");
        this.add((Component)this.rPanel, "East");
        this.jScrollPane1.getViewport().add((Component)this.txtResult, null);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultWKTPanel.this.rCopyButton_actionPerformed(actionEvent);
            }
        });
        this.copyToTestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultWKTPanel.this.copyToTestButton_actionPerformed(actionEvent);
            }
        });
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public void setOpName(String string) {
        this.opName = string == null ? "" : StringUtil.capitalize(string);
    }

    public void setRunningTime(String string) {
        this.setExecutedTime(string);
    }

    public void setExecutedTime(String string) {
        this.functionLabel.setText(this.opName);
        this.timeLabel.setText(string);
        this.memoryLabel.setText(Memory.usedTotalString());
    }

    public void setResult(Object object) {
        this.currResult = object;
        if (object == null) {
            this.setString("");
        } else if (object instanceof Geometry) {
            this.setGeometry((Geometry)object);
        } else if (object instanceof Throwable) {
            this.setError((Throwable)object);
        } else {
            this.setString(object.toString());
        }
    }

    public void clearResult() {
        this.currResult = null;
        this.functionLabel.setText("");
        this.setString("");
    }

    public Object getResult() {
        return this.currResult;
    }

    private void setGeometry(Geometry geometry) {
        String string = this.tbModel.getResultDisplayString(geometry);
        this.txtResult.setText(string);
        this.txtResult.setBackground(SystemColor.control);
    }

    private void setString(String string) {
        this.txtResult.setText(string);
        this.txtResult.setBackground(SystemColor.control);
    }

    private void setError(Throwable throwable) {
        String string = ExceptionFormatter.getFullString(throwable);
        this.txtResult.setText(string);
        this.txtResult.setBackground(Color.pink);
    }

    void rCopyButton_actionPerformed(ActionEvent actionEvent) {
        this.copy(actionEvent);
    }

    void copy(ActionEvent actionEvent) {
        boolean bl = 0 != (actionEvent.getModifiers() & 2);
        SwingUtil.copyToClipboard(this.currResult, bl);
    }

    void copyToTestButton_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilderFrame.getInstance().copyResultToTest();
    }
}

