/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.VertexTaggedGeometryDataMapper;
import com.vividsolutions.jts.triangulate.VoronoiDiagramBuilder;
import com.vividsolutions.jtstest.util.GeometryDataUtil;
import java.util.Collection;

public class TriangulationFunctions {
    private static final double TRIANGULATION_TOLERANCE = 0.0;

    public static Geometry delaunayEdges(Geometry geometry) {
        DelaunayTriangulationBuilder delaunayTriangulationBuilder = new DelaunayTriangulationBuilder();
        delaunayTriangulationBuilder.setSites(geometry);
        delaunayTriangulationBuilder.setTolerance(0.0);
        Geometry geometry2 = delaunayTriangulationBuilder.getEdges(geometry.getFactory());
        return geometry2;
    }

    public static Geometry delaunayTriangles(Geometry geometry) {
        DelaunayTriangulationBuilder delaunayTriangulationBuilder = new DelaunayTriangulationBuilder();
        delaunayTriangulationBuilder.setSites(geometry);
        delaunayTriangulationBuilder.setTolerance(0.0);
        Geometry geometry2 = delaunayTriangulationBuilder.getTriangles(geometry.getFactory());
        return geometry2;
    }

    public static Geometry voronoiDiagram(Geometry geometry, Geometry geometry2) {
        VoronoiDiagramBuilder voronoiDiagramBuilder = new VoronoiDiagramBuilder();
        voronoiDiagramBuilder.setSites(geometry);
        if (geometry2 != null) {
            voronoiDiagramBuilder.setClipEnvelope(geometry2.getEnvelopeInternal());
        }
        voronoiDiagramBuilder.setTolerance(0.0);
        Geometry geometry3 = voronoiDiagramBuilder.getDiagram(geometry.getFactory());
        return geometry3;
    }

    public static Geometry voronoiDiagramWithData(Geometry geometry, Geometry geometry2) {
        GeometryDataUtil.setComponentDataToIndex(geometry);
        VertexTaggedGeometryDataMapper vertexTaggedGeometryDataMapper = new VertexTaggedGeometryDataMapper();
        vertexTaggedGeometryDataMapper.loadSourceGeometries(geometry);
        VoronoiDiagramBuilder voronoiDiagramBuilder = new VoronoiDiagramBuilder();
        voronoiDiagramBuilder.setSites((Collection)vertexTaggedGeometryDataMapper.getCoordinates());
        if (geometry2 != null) {
            voronoiDiagramBuilder.setClipEnvelope(geometry2.getEnvelopeInternal());
        }
        voronoiDiagramBuilder.setTolerance(0.0);
        Geometry geometry3 = voronoiDiagramBuilder.getDiagram(geometry.getFactory());
        vertexTaggedGeometryDataMapper.transferData(geometry3);
        return geometry3;
    }

    public static Geometry conformingDelaunayEdges(Geometry geometry, Geometry geometry2) {
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        conformingDelaunayTriangulationBuilder.setSites(geometry);
        conformingDelaunayTriangulationBuilder.setConstraints(geometry2);
        conformingDelaunayTriangulationBuilder.setTolerance(0.0);
        GeometryFactory geometryFactory = geometry != null ? geometry.getFactory() : geometry2.getFactory();
        Geometry geometry3 = conformingDelaunayTriangulationBuilder.getEdges(geometryFactory);
        return geometry3;
    }

    public static Geometry conformingDelaunayTriangles(Geometry geometry, Geometry geometry2) {
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        conformingDelaunayTriangulationBuilder.setSites(geometry);
        conformingDelaunayTriangulationBuilder.setConstraints(geometry2);
        conformingDelaunayTriangulationBuilder.setTolerance(0.0);
        GeometryFactory geometryFactory = geometry != null ? geometry.getFactory() : geometry2.getFactory();
        Geometry geometry3 = conformingDelaunayTriangulationBuilder.getTriangles(geometryFactory);
        return geometry3;
    }
}

