/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jtstest.function.FunctionsUtil;

public class TriangleFunctions {
    public static Geometry circumcentre(Geometry geometry) {
        Coordinate[] coordinateArray = TriangleFunctions.trianglePts(geometry);
        Coordinate coordinate = Triangle.circumcentre((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinateArray[2]);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        return geometryFactory.createPoint(coordinate);
    }

    public static Geometry perpendicularBisectors(Geometry geometry) {
        Coordinate[] coordinateArray = TriangleFunctions.trianglePts(geometry);
        Coordinate coordinate = Triangle.circumcentre((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinateArray[2]);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        LineString[] lineStringArray = new LineString[3];
        Coordinate coordinate2 = new LineSegment(coordinateArray[1], coordinateArray[2]).closestPoint(coordinate);
        lineStringArray[0] = geometryFactory.createLineString(new Coordinate[]{coordinate2, coordinate});
        Coordinate coordinate3 = new LineSegment(coordinateArray[0], coordinateArray[2]).closestPoint(coordinate);
        lineStringArray[1] = geometryFactory.createLineString(new Coordinate[]{coordinate3, coordinate});
        Coordinate coordinate4 = new LineSegment(coordinateArray[0], coordinateArray[1]).closestPoint(coordinate);
        lineStringArray[2] = geometryFactory.createLineString(new Coordinate[]{coordinate4, coordinate});
        return geometryFactory.createMultiLineString(lineStringArray);
    }

    public static Geometry incentre(Geometry geometry) {
        Coordinate[] coordinateArray = TriangleFunctions.trianglePts(geometry);
        Coordinate coordinate = Triangle.inCentre((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinateArray[2]);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        return geometryFactory.createPoint(coordinate);
    }

    public static Geometry angleBisectors(Geometry geometry) {
        Coordinate[] coordinateArray = TriangleFunctions.trianglePts(geometry);
        Coordinate coordinate = Triangle.inCentre((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinateArray[2]);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        LineString[] lineStringArray = new LineString[]{geometryFactory.createLineString(new Coordinate[]{coordinateArray[0], coordinate}), geometryFactory.createLineString(new Coordinate[]{coordinateArray[1], coordinate}), geometryFactory.createLineString(new Coordinate[]{coordinateArray[2], coordinate})};
        return geometryFactory.createMultiLineString(lineStringArray);
    }

    private static Coordinate[] trianglePts(Geometry geometry) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        if (coordinateArray.length < 3) {
            throw new IllegalArgumentException("Input geometry must have at least 3 points");
        }
        return coordinateArray;
    }
}

