/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class OraReader {
    private GeometryFactory geometryFactory;
    public static final int NULL_DIMENSION = -1;
    private int dimension = -1;

    public OraReader() {
        this(new GeometryFactory());
    }

    public OraReader(GeometryFactory geometryFactory) {
        if (geometryFactory == null) {
            throw new NullPointerException("Geometry Factory may not be Null");
        }
        this.geometryFactory = geometryFactory;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int n) {
        this.dimension = n;
    }

    public Geometry read(STRUCT sTRUCT) throws SQLException {
        if (sTRUCT == null) {
            return null;
        }
        Datum[] datumArray = sTRUCT.getOracleAttributes();
        int n = this.asInteger(datumArray[0], 0);
        int n2 = this.asInteger(datumArray[1], -1);
        double[] dArray = this.asDoubleArray((STRUCT)datumArray[2], Double.NaN);
        int[] nArray = this.asIntArray((ARRAY)datumArray[3], 0);
        double[] dArray2 = this.asDoubleArray((ARRAY)datumArray[4], Double.NaN);
        GeometryFactory geometryFactory = this.geometryFactory;
        if (this.geometryFactory.getSRID() != n2) {
            geometryFactory = new GeometryFactory(this.geometryFactory.getPrecisionModel(), n2, this.geometryFactory.getCoordinateSequenceFactory());
        }
        return this.create(geometryFactory, n, dArray, nArray, dArray2);
    }

    private Geometry create(GeometryFactory geometryFactory, int n, double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = n % 1000 / 100;
        int n3 = 0;
        n3 = this.dimension != -1 ? this.dimension : Math.min(n / 1000, geometryFactory.getCoordinateSequenceFactory().create(0, 0).getDimension());
        if (n3 < 2) {
            throw new IllegalArgumentException("Dimension D:" + n3 + " is not valid for JTS. " + "Either specify a dimension or use Oracle Locator Version 9i or later");
        }
        int n4 = n - n3 * 1000 - n2 * 100;
        CoordinateSequence coordinateSequence = null;
        if (n2 == 0 && n4 == 1 && dArray != null && nArray == null) {
            coordinateSequence = this.coordinates(geometryFactory.getCoordinateSequenceFactory(), n3, n2, n4, dArray);
            nArray = new int[]{1, 1, 1};
        } else {
            coordinateSequence = this.coordinates(geometryFactory.getCoordinateSequenceFactory(), n3, n2, n4, dArray2);
        }
        switch (n4) {
            case 1: {
                return this.createPoint(geometryFactory, n3, n2, nArray, 0, coordinateSequence);
            }
            case 2: {
                return this.createLine(geometryFactory, n3, n2, nArray, 0, coordinateSequence);
            }
            case 3: {
                return this.createPolygon(geometryFactory, n3, n2, nArray, 0, coordinateSequence);
            }
            case 5: {
                return this.createMultiPoint(geometryFactory, n3, n2, nArray, 0, coordinateSequence);
            }
            case 6: {
                return this.createMultiLine(geometryFactory, n3, n2, nArray, 0, coordinateSequence, -1);
            }
            case 7: {
                return this.createMultiPolygon(geometryFactory, n3, n2, nArray, 0, coordinateSequence, -1);
            }
            case 4: {
                return this.createCollection(geometryFactory, n3, n2, nArray, 0, coordinateSequence, -1);
            }
        }
        return null;
    }

    private CoordinateSequence coordinates(CoordinateSequenceFactory coordinateSequenceFactory, int n, int n2, int n3, double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return coordinateSequenceFactory.create(new Coordinate[0]);
        }
        if (n == 2 && n2 == 0 && n3 == 1 && dArray.length == 3) {
            return coordinateSequenceFactory.create(new Coordinate[]{new Coordinate(dArray[0], dArray[1], dArray[2])});
        }
        int n4 = n + n2;
        if (n4 == 0 && dArray.length != 0 || n4 != 0 && dArray.length % n4 != 0) {
            throw new IllegalArgumentException("Dimension D:" + n + " and L:" + n2 + " denote Coordinates " + "of " + n4 + " ordinates. This cannot be resolved with" + "an ordinate array of length " + dArray.length);
        }
        int n5 = n4 == 0 ? 0 : dArray.length / n4;
        CoordinateSequence coordinateSequence = coordinateSequenceFactory.create(n5, n);
        int n6 = coordinateSequence.getDimension();
        for (int i = 0; i < n5; ++i) {
            int n7;
            for (n7 = 0; n7 < n6 && n7 < n; ++n7) {
                coordinateSequence.setOrdinate(i, n7, dArray[i * n4 + n7]);
            }
            int n8 = n7;
            while (n7 < n6 && n7 - n8 < n2) {
                coordinateSequence.setOrdinate(i, n7, dArray[i * n4 + n7]);
                ++n7;
            }
        }
        return coordinateSequence;
    }

    private GeometryCollection createCollection(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence, int n4) {
        int n5;
        int n6 = this.StartingOffset(nArray, n3);
        if (n6 > (n5 = coordinateSequence.size() * n)) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n6 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        int n7 = n4 != -1 ? n3 + n4 : nArray.length / 3 + 1;
        LinkedList<LineString> linkedList = new LinkedList<LineString>();
        boolean bl = true;
        for (int i = n3; bl && i < n7; ++i) {
            LineString lineString;
            int n8 = this.eType(nArray, i);
            int n9 = this.interpretation(nArray, i);
            switch (n8) {
                case -1: {
                    bl = false;
                }
                case 1: {
                    if (n9 == 1) {
                        lineString = this.createPoint(geometryFactory, n, n2, nArray, i, coordinateSequence);
                        break;
                    }
                    if (n9 > 1) {
                        lineString = this.createMultiPoint(geometryFactory, n, n2, nArray, i, coordinateSequence);
                        break;
                    }
                    throw new IllegalArgumentException("ETYPE.POINT requires INTERPRETATION >= 1");
                }
                case 2: {
                    lineString = this.createLine(geometryFactory, n, n2, nArray, i, coordinateSequence);
                    break;
                }
                case 3: 
                case 1003: {
                    lineString = this.createPolygon(geometryFactory, n, n2, nArray, i, coordinateSequence);
                    i += ((Polygon)lineString).getNumInteriorRing();
                    break;
                }
                case 2003: {
                    throw new IllegalArgumentException("ETYPE 2003 (Polygon Interior) no expected in a GeometryCollection(2003 is used to represent polygon holes, in a 1003 polygon exterior)");
                }
                default: {
                    throw new IllegalArgumentException("ETYPE " + n8 + " not representable as a JTS Geometry." + "(Custom and Compound Straight and Curved Geometries not supported)");
                }
            }
            linkedList.add(lineString);
        }
        GeometryCollection geometryCollection = geometryFactory.createGeometryCollection(linkedList.toArray(new Geometry[linkedList.size()]));
        return geometryCollection;
    }

    private MultiPolygon createMultiPolygon(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence, int n4) {
        int n5 = this.StartingOffset(nArray, n3);
        int n6 = this.eType(nArray, n3);
        int n7 = this.interpretation(nArray, n3);
        int n8 = coordinateSequence.size() * n;
        if (n5 < 1 || n5 > n8) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n5 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        if (n6 != 3 && n6 != 1003) {
            throw new IllegalArgumentException("ETYPE " + n6 + " inconsistent with expected POLYGON or POLYGON_EXTERIOR");
        }
        if (n7 != 1 && n7 != 3) {
            return null;
        }
        int n9 = n4 != -1 ? n3 + n4 : nArray.length / 3 + 1;
        LinkedList<Polygon> linkedList = new LinkedList<Polygon>();
        boolean bl = true;
        for (int i = n3; bl && i < n9 && (n6 = this.eType(nArray, i)) != -1; ++i) {
            if (n6 == 3 || n6 == 1003) {
                Polygon polygon = this.createPolygon(geometryFactory, n, n2, nArray, i, coordinateSequence);
                i += polygon.getNumInteriorRing();
                linkedList.add(polygon);
                continue;
            }
            bl = false;
        }
        MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(linkedList.toArray(new Polygon[linkedList.size()]));
        return multiPolygon;
    }

    private MultiLineString createMultiLine(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence, int n4) {
        int n5 = this.StartingOffset(nArray, n3);
        int n6 = this.eType(nArray, n3);
        int n7 = this.interpretation(nArray, n3);
        int n8 = coordinateSequence.size() * n;
        if (n5 < 1 || n5 > n8) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n5 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        if (n6 != 2) {
            throw new IllegalArgumentException("ETYPE " + n6 + " inconsistent with expected LINE");
        }
        if (n7 != 1) {
            return null;
        }
        int n9 = n4 != -1 ? n3 + n4 : nArray.length / 3;
        LinkedList<LineString> linkedList = new LinkedList<LineString>();
        boolean bl = true;
        for (int i = n3; bl && i < n9 && (n6 = this.eType(nArray, i)) != -1; ++i) {
            if (n6 == 2) {
                linkedList.add(this.createLine(geometryFactory, n, n2, nArray, i, coordinateSequence));
                continue;
            }
            bl = false;
        }
        MultiLineString multiLineString = geometryFactory.createMultiLineString(linkedList.toArray(new LineString[linkedList.size()]));
        return multiLineString;
    }

    private MultiPoint createMultiPoint(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence) {
        int n4 = this.StartingOffset(nArray, n3);
        int n5 = this.eType(nArray, n3);
        int n6 = this.interpretation(nArray, n3);
        if (n4 < 1 || n4 > coordinateSequence.size()) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n4 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        if (n5 != 1) {
            throw new IllegalArgumentException("ETYPE " + n5 + " inconsistent with expected POINT");
        }
        if (n6 <= 1) {
            return null;
        }
        int n7 = n + n2;
        int n8 = (n4 - 1) / n7;
        int n9 = n8 + n6;
        MultiPoint multiPoint = geometryFactory.createMultiPoint(this.subList(geometryFactory.getCoordinateSequenceFactory(), coordinateSequence, n8, n9));
        return multiPoint;
    }

    private Polygon createPolygon(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence) {
        int n4 = this.StartingOffset(nArray, n3);
        int n5 = this.eType(nArray, n3);
        int n6 = this.interpretation(nArray, n3);
        if (1 > n4 || n4 > coordinateSequence.size() * n) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n4 + "inconsistent with COORDINATES length " + coordinateSequence.size() * n);
        }
        if (n5 != 3 && n5 != 1003) {
            throw new IllegalArgumentException("ETYPE " + n5 + " inconsistent with expected POLYGON or POLYGON_EXTERIOR");
        }
        if (n6 != 1 && n6 != 3) {
            return null;
        }
        LinearRing linearRing = this.createLinearRing(geometryFactory, n, n2, nArray, n3, coordinateSequence);
        LinkedList<LinearRing> linkedList = new LinkedList<LinearRing>();
        boolean bl = true;
        int n7 = n3 + 1;
        while (bl && (n5 = this.eType(nArray, n7)) != -1) {
            if (n5 == 2003) {
                linkedList.add(this.createLinearRing(geometryFactory, n, n2, nArray, n7, coordinateSequence));
            } else if (n5 == 3) {
                LinearRing linearRing2 = this.createLinearRing(geometryFactory, n, n2, nArray, n7, coordinateSequence);
                if (CGAlgorithms.isCCW((Coordinate[])linearRing2.getCoordinates())) {
                    linkedList.add(linearRing2);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            ++n7;
        }
        Polygon polygon = geometryFactory.createPolygon(linearRing, linkedList.toArray(new LinearRing[linkedList.size()]));
        return polygon;
    }

    private LinearRing createLinearRing(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence) {
        LinearRing linearRing;
        int n4;
        int n5 = this.StartingOffset(nArray, n3);
        int n6 = this.eType(nArray, n3);
        int n7 = this.interpretation(nArray, n3);
        int n8 = coordinateSequence.size() * n;
        if (n5 > n8) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n5 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        if (n6 != 3 && n6 != 1003 && n6 != 2003) {
            throw new IllegalArgumentException("ETYPE " + n6 + " inconsistent with expected POLYGON, POLYGON_EXTERIOR or POLYGON_INTERIOR");
        }
        if (n7 != 1 && n7 != 3) {
            return null;
        }
        int n9 = n + n2;
        int n10 = (n5 - 1) / n9;
        int n11 = this.StartingOffset(nArray, n3 + 1);
        int n12 = n4 = n11 != -1 ? (n11 - 1) / n9 : coordinateSequence.size();
        if (n7 == 1) {
            linearRing = geometryFactory.createLinearRing(this.subList(geometryFactory.getCoordinateSequenceFactory(), coordinateSequence, n10, n4));
        } else {
            CoordinateSequence coordinateSequence2 = this.subList(geometryFactory.getCoordinateSequenceFactory(), coordinateSequence, n10, n4);
            Coordinate coordinate = coordinateSequence2.getCoordinate(0);
            Coordinate coordinate2 = coordinateSequence2.getCoordinate(1);
            linearRing = geometryFactory.createLinearRing(new Coordinate[]{coordinate, new Coordinate(coordinate2.x, coordinate.y), coordinate2, new Coordinate(coordinate.x, coordinate2.y), coordinate});
        }
        return linearRing;
    }

    private LineString createLine(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence) {
        int n4 = this.StartingOffset(nArray, n3);
        int n5 = this.eType(nArray, n3);
        int n6 = this.interpretation(nArray, n3);
        if (n5 != 2) {
            return null;
        }
        if (n6 != 1) {
            throw new IllegalArgumentException("ELEM_INFO INTERPRETAION " + n6 + " not supported" + "by JTS LineString.  Straight edges" + "( ELEM_INFO INTERPRETAION 1) is supported");
        }
        int n7 = n + n2;
        int n8 = (n4 - 1) / n7;
        int n9 = this.StartingOffset(nArray, n3 + 1);
        int n10 = n9 != -1 ? (n9 - 1) / n7 : coordinateSequence.size();
        LineString lineString = geometryFactory.createLineString(this.subList(geometryFactory.getCoordinateSequenceFactory(), coordinateSequence, n8, n10));
        return lineString;
    }

    private Point createPoint(GeometryFactory geometryFactory, int n, int n2, int[] nArray, int n3, CoordinateSequence coordinateSequence) {
        int n4 = this.StartingOffset(nArray, n3);
        int n5 = this.eType(nArray, n3);
        int n6 = this.interpretation(nArray, n3);
        if (n4 < 1 || n4 > coordinateSequence.size()) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + n4 + " inconsistent with ORDINATES length " + coordinateSequence.size());
        }
        if (n5 != 1) {
            throw new IllegalArgumentException("ETYPE " + n5 + " inconsistent with expected POINT");
        }
        if (n6 != 1) {
            return null;
        }
        int n7 = n + n2;
        int n8 = (n4 - 1) / n7;
        int n9 = this.StartingOffset(nArray, n3 + 1);
        Point point = null;
        if (n4 == 1 && n9 == -1) {
            point = geometryFactory.createPoint(coordinateSequence);
        } else {
            int n10 = n9 != -1 ? (n9 - 1) / n7 : coordinateSequence.size();
            point = geometryFactory.createPoint(this.subList(geometryFactory.getCoordinateSequenceFactory(), coordinateSequence, n8, n10));
        }
        return point;
    }

    private CoordinateSequence subList(CoordinateSequenceFactory coordinateSequenceFactory, CoordinateSequence coordinateSequence, int n, int n2) {
        CoordinateList coordinateList;
        if (n == 0 && n2 == coordinateSequence.size()) {
            return coordinateSequence;
        }
        if (coordinateSequence instanceof List && (coordinateList = ((List)coordinateSequence).subList(n, n2)) instanceof CoordinateSequence) {
            return (CoordinateSequence)coordinateList;
        }
        coordinateList = new CoordinateList(coordinateSequence.toCoordinateArray());
        Coordinate[] coordinateArray = new Coordinate[n2 - n];
        int n3 = 0;
        Iterator iterator = coordinateList.subList(n, n2).iterator();
        while (iterator.hasNext()) {
            coordinateArray[n3] = (Coordinate)iterator.next();
            ++n3;
        }
        return coordinateSequenceFactory.create(coordinateArray);
    }

    private int eType(int[] nArray, int n) {
        if (n * 3 + 1 >= nArray.length) {
            return -1;
        }
        return nArray[n * 3 + 1];
    }

    private int interpretation(int[] nArray, int n) {
        if (n * 3 + 2 >= nArray.length) {
            return -1;
        }
        return nArray[n * 3 + 2];
    }

    private int StartingOffset(int[] nArray, int n) {
        if (n * 3 + 0 >= nArray.length) {
            return -1;
        }
        return nArray[n * 3 + 0];
    }

    private int asInteger(Datum datum, int n) throws SQLException {
        if (datum == null) {
            return n;
        }
        return ((NUMBER)datum).intValue();
    }

    private double asDouble(Datum datum, double d) {
        if (datum == null) {
            return d;
        }
        return ((NUMBER)datum).doubleValue();
    }

    private double[] asDoubleArray(STRUCT sTRUCT, double d) throws SQLException {
        if (sTRUCT == null) {
            return null;
        }
        return this.asDoubleArray(sTRUCT.getOracleAttributes(), d);
    }

    private double[] asDoubleArray(ARRAY aRRAY, double d) throws SQLException {
        if (aRRAY == null) {
            return null;
        }
        if (d == 0.0) {
            return aRRAY.getDoubleArray();
        }
        return this.asDoubleArray(aRRAY.getOracleArray(), d);
    }

    private double[] asDoubleArray(Datum[] datumArray, double d) {
        if (datumArray == null) {
            return null;
        }
        double[] dArray = new double[datumArray.length];
        for (int i = 0; i < datumArray.length; ++i) {
            dArray[i] = this.asDouble(datumArray[i], d);
        }
        return dArray;
    }

    private int[] asIntArray(ARRAY aRRAY, int n) throws SQLException {
        if (aRRAY == null) {
            return null;
        }
        if (n == 0) {
            return aRRAY.getIntArray();
        }
        return this.asIntArray(aRRAY.getOracleArray(), n);
    }

    private int[] asIntArray(Datum[] datumArray, int n) throws SQLException {
        if (datumArray == null) {
            return null;
        }
        int[] nArray = new int[datumArray.length];
        for (int i = 0; i < datumArray.length; ++i) {
            nArray[i] = this.asInteger(datumArray[i], n);
        }
        return nArray;
    }
}

